/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticinference.ElasticInferenceClient;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator;

public class DescribeAcceleratorsIterable
implements SdkIterable<DescribeAcceleratorsResponse> {
    private final ElasticInferenceClient client;
    private final DescribeAcceleratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAcceleratorsIterable(ElasticInferenceClient client, DescribeAcceleratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAcceleratorsResponseFetcher();
    }

    public Iterator<DescribeAcceleratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ElasticInferenceAccelerator> acceleratorSet() {
        Function<DescribeAcceleratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.acceleratorSet() != null) {
                return response.acceleratorSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAcceleratorsResponseFetcher
    implements SyncPageFetcher<DescribeAcceleratorsResponse> {
        private DescribeAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAcceleratorsResponse nextPage(DescribeAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAcceleratorsIterable.this.client.describeAccelerators(DescribeAcceleratorsIterable.this.firstRequest);
            }
            return DescribeAcceleratorsIterable.this.client.describeAccelerators((DescribeAcceleratorsRequest)((Object)DescribeAcceleratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

