/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticinference.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticinference.ElasticInferenceAsyncClient;
import software.amazon.awssdk.services.elasticinference.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest;
import software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse;
import software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator;

public class DescribeAcceleratorsPublisher
implements SdkPublisher<DescribeAcceleratorsResponse> {
    private final ElasticInferenceAsyncClient client;
    private final DescribeAcceleratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAcceleratorsPublisher(ElasticInferenceAsyncClient client, DescribeAcceleratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAcceleratorsPublisher(ElasticInferenceAsyncClient client, DescribeAcceleratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAcceleratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAcceleratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ElasticInferenceAccelerator> acceleratorSet() {
        Function<DescribeAcceleratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.acceleratorSet() != null) {
                return response.acceleratorSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAcceleratorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeAcceleratorsResponseFetcher
    implements AsyncPageFetcher<DescribeAcceleratorsResponse> {
        private DescribeAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAcceleratorsResponse> nextPage(DescribeAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAcceleratorsPublisher.this.client.describeAccelerators(DescribeAcceleratorsPublisher.this.firstRequest);
            }
            return DescribeAcceleratorsPublisher.this.client.describeAccelerators((DescribeAcceleratorsRequest)((Object)DescribeAcceleratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

