/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Architecture {
    ARM64("ARM64"),
    X86_64("X86_64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Architecture> VALUE_MAP;
    private final String value;

    private Architecture(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Architecture fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Architecture> knownValues() {
        EnumSet<Architecture> knownValues = EnumSet.allOf(Architecture.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Architecture.class, Architecture::toString);
    }
}

