/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrserverless.model.EmrServerlessRequest;
import software.amazon.awssdk.services.emrserverless.model.JobRunMode;
import software.amazon.awssdk.services.emrserverless.model.JobRunState;
import software.amazon.awssdk.services.emrserverless.model.JobRunStateSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobRunsRequest
extends EmrServerlessRequest
implements ToCopyableBuilder<Builder, ListJobRunsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(ListJobRunsRequest.getter(ListJobRunsRequest::applicationId)).setter(ListJobRunsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobRunsRequest.getter(ListJobRunsRequest::nextToken)).setter(ListJobRunsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListJobRunsRequest.getter(ListJobRunsRequest::maxResults)).setter(ListJobRunsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<Instant> CREATED_AT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAtAfter").getter(ListJobRunsRequest.getter(ListJobRunsRequest::createdAtAfter)).setter(ListJobRunsRequest.setter(Builder::createdAtAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAtAfter").build()}).build();
    private static final SdkField<Instant> CREATED_AT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAtBefore").getter(ListJobRunsRequest.getter(ListJobRunsRequest::createdAtBefore)).setter(ListJobRunsRequest.setter(Builder::createdAtBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAtBefore").build()}).build();
    private static final SdkField<List<String>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("states").getter(ListJobRunsRequest.getter(ListJobRunsRequest::statesAsStrings)).setter(ListJobRunsRequest.setter(Builder::statesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(ListJobRunsRequest.getter(ListJobRunsRequest::modeAsString)).setter(ListJobRunsRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CREATED_AT_AFTER_FIELD, CREATED_AT_BEFORE_FIELD, STATES_FIELD, MODE_FIELD));
    private final String applicationId;
    private final String nextToken;
    private final Integer maxResults;
    private final Instant createdAtAfter;
    private final Instant createdAtBefore;
    private final List<String> states;
    private final String mode;

    private ListJobRunsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.createdAtAfter = builder.createdAtAfter;
        this.createdAtBefore = builder.createdAtBefore;
        this.states = builder.states;
        this.mode = builder.mode;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final Instant createdAtAfter() {
        return this.createdAtAfter;
    }

    public final Instant createdAtBefore() {
        return this.createdAtBefore;
    }

    public final List<JobRunState> states() {
        return JobRunStateSetCopier.copyStringToEnum(this.states);
    }

    public final boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public final List<String> statesAsStrings() {
        return this.states;
    }

    public final JobRunMode mode() {
        return JobRunMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStates() ? this.statesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobRunsRequest)) {
            return false;
        }
        ListJobRunsRequest other = (ListJobRunsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.createdAtAfter(), other.createdAtAfter()) && Objects.equals(this.createdAtBefore(), other.createdAtBefore()) && this.hasStates() == other.hasStates() && Objects.equals(this.statesAsStrings(), other.statesAsStrings()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListJobRunsRequest").add("ApplicationId", (Object)this.applicationId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("CreatedAtAfter", (Object)this.createdAtAfter()).add("CreatedAtBefore", (Object)this.createdAtBefore()).add("States", this.hasStates() ? this.statesAsStrings() : null).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "createdAtAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAtAfter()));
            }
            case "createdAtBefore": {
                return Optional.ofNullable(clazz.cast(this.createdAtBefore()));
            }
            case "states": {
                return Optional.ofNullable(clazz.cast(this.statesAsStrings()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobRunsRequest, T> g) {
        return obj -> g.apply((ListJobRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrServerlessRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String nextToken;
        private Integer maxResults;
        private Instant createdAtAfter;
        private Instant createdAtBefore;
        private List<String> states = DefaultSdkAutoConstructList.getInstance();
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobRunsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.createdAtAfter(model.createdAtAfter);
            this.createdAtBefore(model.createdAtBefore);
            this.statesWithStrings(model.states);
            this.mode(model.mode);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreatedAtAfter() {
            return this.createdAtAfter;
        }

        public final void setCreatedAtAfter(Instant createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
        }

        @Override
        public final Builder createdAtAfter(Instant createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
            return this;
        }

        public final Instant getCreatedAtBefore() {
            return this.createdAtBefore;
        }

        public final void setCreatedAtBefore(Instant createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
        }

        @Override
        public final Builder createdAtBefore(Instant createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        public final Collection<String> getStates() {
            if (this.states instanceof SdkAutoConstructList) {
                return null;
            }
            return this.states;
        }

        public final void setStates(Collection<String> states) {
            this.states = JobRunStateSetCopier.copy(states);
        }

        @Override
        public final Builder statesWithStrings(Collection<String> states) {
            this.states = JobRunStateSetCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statesWithStrings(String ... states) {
            this.statesWithStrings(Arrays.asList(states));
            return this;
        }

        @Override
        public final Builder states(Collection<JobRunState> states) {
            this.states = JobRunStateSetCopier.copyEnumToString(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(JobRunState ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobRunsRequest build() {
            return new ListJobRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobRunsRequest> {
        public Builder applicationId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder createdAtAfter(Instant var1);

        public Builder createdAtBefore(Instant var1);

        public Builder statesWithStrings(Collection<String> var1);

        public Builder statesWithStrings(String ... var1);

        public Builder states(Collection<JobRunState> var1);

        public Builder states(JobRunState ... var1);

        public Builder mode(String var1);

        public Builder mode(JobRunMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

