/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVaultResponse extends GlacierResponse implements
        ToCopyableBuilder<DescribeVaultResponse.Builder, DescribeVaultResponse> {
    private static final SdkField<String> VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultARN").getter(getter(DescribeVaultResponse::vaultARN)).setter(setter(Builder::vaultARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultARN").build()).build();

    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultName").getter(getter(DescribeVaultResponse::vaultName)).setter(setter(Builder::vaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultName").build()).build();

    private static final SdkField<String> CREATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDate").getter(getter(DescribeVaultResponse::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<String> LAST_INVENTORY_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastInventoryDate").getter(getter(DescribeVaultResponse::lastInventoryDate))
            .setter(setter(Builder::lastInventoryDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastInventoryDate").build()).build();

    private static final SdkField<Long> NUMBER_OF_ARCHIVES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfArchives").getter(getter(DescribeVaultResponse::numberOfArchives))
            .setter(setter(Builder::numberOfArchives))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfArchives").build()).build();

    private static final SdkField<Long> SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SizeInBytes").getter(getter(DescribeVaultResponse::sizeInBytes)).setter(setter(Builder::sizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VAULT_ARN_FIELD,
            VAULT_NAME_FIELD, CREATION_DATE_FIELD, LAST_INVENTORY_DATE_FIELD, NUMBER_OF_ARCHIVES_FIELD, SIZE_IN_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vaultARN;

    private final String vaultName;

    private final String creationDate;

    private final String lastInventoryDate;

    private final Long numberOfArchives;

    private final Long sizeInBytes;

    private DescribeVaultResponse(BuilderImpl builder) {
        super(builder);
        this.vaultARN = builder.vaultARN;
        this.vaultName = builder.vaultName;
        this.creationDate = builder.creationDate;
        this.lastInventoryDate = builder.lastInventoryDate;
        this.numberOfArchives = builder.numberOfArchives;
        this.sizeInBytes = builder.sizeInBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vault.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vault.
     */
    public final String vaultARN() {
        return vaultARN;
    }

    /**
     * <p>
     * The name of the vault.
     * </p>
     * 
     * @return The name of the vault.
     */
    public final String vaultName() {
        return vaultName;
    }

    /**
     * <p>
     * The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the ISO
     * 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
     * </p>
     * 
     * @return The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in
     *         the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
     */
    public final String creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This value
     * should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
     * </p>
     * 
     * @return The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This
     *         value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
     */
    public final String lastInventoryDate() {
        return lastInventoryDate;
    }

    /**
     * <p>
     * The number of archives in the vault as of the last inventory date. This field will return <code>null</code> if an
     * inventory has not yet run on the vault, for example if you just created the vault.
     * </p>
     * 
     * @return The number of archives in the vault as of the last inventory date. This field will return
     *         <code>null</code> if an inventory has not yet run on the vault, for example if you just created the
     *         vault.
     */
    public final Long numberOfArchives() {
        return numberOfArchives;
    }

    /**
     * <p>
     * Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null if
     * an inventory has not yet run on the vault, for example if you just created the vault.
     * </p>
     * 
     * @return Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return
     *         null if an inventory has not yet run on the vault, for example if you just created the vault.
     */
    public final Long sizeInBytes() {
        return sizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vaultARN());
        hashCode = 31 * hashCode + Objects.hashCode(vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastInventoryDate());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfArchives());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVaultResponse)) {
            return false;
        }
        DescribeVaultResponse other = (DescribeVaultResponse) obj;
        return Objects.equals(vaultARN(), other.vaultARN()) && Objects.equals(vaultName(), other.vaultName())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastInventoryDate(), other.lastInventoryDate())
                && Objects.equals(numberOfArchives(), other.numberOfArchives())
                && Objects.equals(sizeInBytes(), other.sizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVaultResponse").add("VaultARN", vaultARN()).add("VaultName", vaultName())
                .add("CreationDate", creationDate()).add("LastInventoryDate", lastInventoryDate())
                .add("NumberOfArchives", numberOfArchives()).add("SizeInBytes", sizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VaultARN":
            return Optional.ofNullable(clazz.cast(vaultARN()));
        case "VaultName":
            return Optional.ofNullable(clazz.cast(vaultName()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "LastInventoryDate":
            return Optional.ofNullable(clazz.cast(lastInventoryDate()));
        case "NumberOfArchives":
            return Optional.ofNullable(clazz.cast(numberOfArchives()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VaultARN", VAULT_ARN_FIELD);
        map.put("VaultName", VAULT_NAME_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("LastInventoryDate", LAST_INVENTORY_DATE_FIELD);
        map.put("NumberOfArchives", NUMBER_OF_ARCHIVES_FIELD);
        map.put("SizeInBytes", SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVaultResponse, T> g) {
        return obj -> g.apply((DescribeVaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVaultResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vault.
         * </p>
         * 
         * @param vaultARN
         *        The Amazon Resource Name (ARN) of the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultARN(String vaultARN);

        /**
         * <p>
         * The name of the vault.
         * </p>
         * 
         * @param vaultName
         *        The name of the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultName(String vaultName);

        /**
         * <p>
         * The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in the
         * ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
         * </p>
         * 
         * @param creationDate
         *        The Universal Coordinated Time (UTC) date when the vault was created. This value should be a string in
         *        the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(String creationDate);

        /**
         * <p>
         * The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory. This
         * value should be a string in the ISO 8601 date format, for example <code>2012-03-20T17:03:43.221Z</code>.
         * </p>
         * 
         * @param lastInventoryDate
         *        The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed the last vault inventory.
         *        This value should be a string in the ISO 8601 date format, for example
         *        <code>2012-03-20T17:03:43.221Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastInventoryDate(String lastInventoryDate);

        /**
         * <p>
         * The number of archives in the vault as of the last inventory date. This field will return <code>null</code>
         * if an inventory has not yet run on the vault, for example if you just created the vault.
         * </p>
         * 
         * @param numberOfArchives
         *        The number of archives in the vault as of the last inventory date. This field will return
         *        <code>null</code> if an inventory has not yet run on the vault, for example if you just created the
         *        vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfArchives(Long numberOfArchives);

        /**
         * <p>
         * Total size, in bytes, of the archives in the vault as of the last inventory date. This field will return null
         * if an inventory has not yet run on the vault, for example if you just created the vault.
         * </p>
         * 
         * @param sizeInBytes
         *        Total size, in bytes, of the archives in the vault as of the last inventory date. This field will
         *        return null if an inventory has not yet run on the vault, for example if you just created the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(Long sizeInBytes);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String vaultARN;

        private String vaultName;

        private String creationDate;

        private String lastInventoryDate;

        private Long numberOfArchives;

        private Long sizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVaultResponse model) {
            super(model);
            vaultARN(model.vaultARN);
            vaultName(model.vaultName);
            creationDate(model.creationDate);
            lastInventoryDate(model.lastInventoryDate);
            numberOfArchives(model.numberOfArchives);
            sizeInBytes(model.sizeInBytes);
        }

        public final String getVaultARN() {
            return vaultARN;
        }

        public final void setVaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
        }

        @Override
        public final Builder vaultARN(String vaultARN) {
            this.vaultARN = vaultARN;
            return this;
        }

        public final String getVaultName() {
            return vaultName;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final String getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastInventoryDate() {
            return lastInventoryDate;
        }

        public final void setLastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
        }

        @Override
        public final Builder lastInventoryDate(String lastInventoryDate) {
            this.lastInventoryDate = lastInventoryDate;
            return this;
        }

        public final Long getNumberOfArchives() {
            return numberOfArchives;
        }

        public final void setNumberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
        }

        @Override
        public final Builder numberOfArchives(Long numberOfArchives) {
            this.numberOfArchives = numberOfArchives;
            return this;
        }

        public final Long getSizeInBytes() {
            return sizeInBytes;
        }

        public final void setSizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public final Builder sizeInBytes(Long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        @Override
        public DescribeVaultResponse build() {
            return new DescribeVaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
