/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.glacier.transform.DefaultAccountIdSupplier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides options for downloading output of an Amazon S3 Glacier job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobOutputRequest extends GlacierRequest implements
        ToCopyableBuilder<GetJobOutputRequest.Builder, GetJobOutputRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accountId")
            .getter(getter(GetJobOutputRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build(),
                    DefaultValueTrait.create(DefaultAccountIdSupplier.getInstance())).build();

    private static final SdkField<String> VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vaultName").getter(getter(GetJobOutputRequest::vaultName)).setter(setter(Builder::vaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vaultName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(GetJobOutputRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("range")
            .getter(getter(GetJobOutputRequest::range)).setter(setter(Builder::range))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            VAULT_NAME_FIELD, JOB_ID_FIELD, RANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String vaultName;

    private final String jobId;

    private final String range;

    private GetJobOutputRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.vaultName = builder.vaultName;
        this.jobId = builder.jobId;
        this.range = builder.range;
    }

    /**
     * <p>
     * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either specify
     * an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier uses the AWS
     * account ID associated with the credentials used to sign the request. If you use an account ID, do not include any
     * hyphens ('-') in the ID.
     * </p>
     * 
     * @return The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
     *         specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3
     *         Glacier uses the AWS account ID associated with the credentials used to sign the request. If you use an
     *         account ID, do not include any hyphens ('-') in the ID.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the vault.
     * </p>
     * 
     * @return The name of the vault.
     */
    public final String vaultName() {
        return vaultName;
    }

    /**
     * <p>
     * The job ID whose data is downloaded.
     * </p>
     * 
     * @return The job ID whose data is downloaded.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576 bytes,
     * specify the range as <code>bytes=0-1048575</code>. By default, this operation downloads the entire output.
     * </p>
     * <p>
     * If the job output is large, then you can use a range to retrieve a portion of the output. This allows you to
     * download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job output you want
     * to download and you decide to download 128 MB chunks of data at a time, which is a total of eight Get Job Output
     * requests. You use the following process to download the job output:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of data was
     * received.
     * </p>
     * </li>
     * <li>
     * <p>
     * Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of the
     * payload on the client and compare it with the checksum you received in the response to ensure you received all
     * the expected data.
     * </p>
     * </li>
     * <li>
     * <p>
     * Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate byte
     * range.
     * </p>
     * </li>
     * <li>
     * <p>
     * After downloading all the parts of the job output, you have a list of eight checksum values. Compute the tree
     * hash of these values to find the checksum of the entire output. Using the <a>DescribeJob</a> API, obtain job
     * information of the job that provided you the output. The response includes the checksum of the entire archive
     * stored in Amazon S3 Glacier. You compare this value with the checksum you computed to ensure you have downloaded
     * the entire archive content with no errors.
     * </p>
     * <p/></li>
     * </ol>
     * 
     * @return The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576
     *         bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation downloads the entire
     *         output.</p>
     *         <p>
     *         If the job output is large, then you can use a range to retrieve a portion of the output. This allows you
     *         to download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job
     *         output you want to download and you decide to download 128 MB chunks of data at a time, which is a total
     *         of eight Get Job Output requests. You use the following process to download the job output:
     *         </p>
     *         <ol>
     *         <li>
     *         <p>
     *         Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of
     *         data was received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of
     *         the payload on the client and compare it with the checksum you received in the response to ensure you
     *         received all the expected data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate
     *         byte range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         After downloading all the parts of the job output, you have a list of eight checksum values. Compute the
     *         tree hash of these values to find the checksum of the entire output. Using the <a>DescribeJob</a> API,
     *         obtain job information of the job that provided you the output. The response includes the checksum of the
     *         entire archive stored in Amazon S3 Glacier. You compare this value with the checksum you computed to
     *         ensure you have downloaded the entire archive content with no errors.
     *         </p>
     *         <p/></li>
     */
    public final String range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(vaultName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobOutputRequest)) {
            return false;
        }
        GetJobOutputRequest other = (GetJobOutputRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(vaultName(), other.vaultName())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobOutputRequest").add("AccountId", accountId()).add("VaultName", vaultName())
                .add("JobId", jobId()).add("Range", range()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "vaultName":
            return Optional.ofNullable(clazz.cast(vaultName()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("vaultName", VAULT_NAME_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("Range", RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobOutputRequest, T> g) {
        return obj -> g.apply((GetJobOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetJobOutputRequest> {
        /**
         * <p>
         * The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can either
         * specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case Amazon S3 Glacier
         * uses the AWS account ID associated with the credentials used to sign the request. If you use an account ID,
         * do not include any hyphens ('-') in the ID.
         * </p>
         * 
         * @param accountId
         *        The <code>AccountId</code> value is the AWS account ID of the account that owns the vault. You can
         *        either specify an AWS account ID or optionally a single '<code>-</code>' (hyphen), in which case
         *        Amazon S3 Glacier uses the AWS account ID associated with the credentials used to sign the request. If
         *        you use an account ID, do not include any hyphens ('-') in the ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the vault.
         * </p>
         * 
         * @param vaultName
         *        The name of the vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vaultName(String vaultName);

        /**
         * <p>
         * The job ID whose data is downloaded.
         * </p>
         * 
         * @param jobId
         *        The job ID whose data is downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The range of bytes to retrieve from the output. For example, if you want to download the first 1,048,576
         * bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation downloads the entire
         * output.
         * </p>
         * <p>
         * If the job output is large, then you can use a range to retrieve a portion of the output. This allows you to
         * download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of job output you
         * want to download and you decide to download 128 MB chunks of data at a time, which is a total of eight Get
         * Job Output requests. You use the following process to download the job output:
         * </p>
         * <ol>
         * <li>
         * <p>
         * Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of data
         * was received.
         * </p>
         * </li>
         * <li>
         * <p>
         * Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum of the
         * payload on the client and compare it with the checksum you received in the response to ensure you received
         * all the expected data.
         * </p>
         * </li>
         * <li>
         * <p>
         * Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the appropriate
         * byte range.
         * </p>
         * </li>
         * <li>
         * <p>
         * After downloading all the parts of the job output, you have a list of eight checksum values. Compute the tree
         * hash of these values to find the checksum of the entire output. Using the <a>DescribeJob</a> API, obtain job
         * information of the job that provided you the output. The response includes the checksum of the entire archive
         * stored in Amazon S3 Glacier. You compare this value with the checksum you computed to ensure you have
         * downloaded the entire archive content with no errors.
         * </p>
         * <p/></li>
         * </ol>
         * 
         * @param range
         *        The range of bytes to retrieve from the output. For example, if you want to download the first
         *        1,048,576 bytes, specify the range as <code>bytes=0-1048575</code>. By default, this operation
         *        downloads the entire output.</p>
         *        <p>
         *        If the job output is large, then you can use a range to retrieve a portion of the output. This allows
         *        you to download the entire output in smaller chunks of bytes. For example, suppose you have 1 GB of
         *        job output you want to download and you decide to download 128 MB chunks of data at a time, which is a
         *        total of eight Get Job Output requests. You use the following process to download the job output:
         *        </p>
         *        <ol>
         *        <li>
         *        <p>
         *        Download a 128 MB chunk of output by specifying the appropriate byte range. Verify that all 128 MB of
         *        data was received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Along with the data, the response includes a SHA256 tree hash of the payload. You compute the checksum
         *        of the payload on the client and compare it with the checksum you received in the response to ensure
         *        you received all the expected data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each time specifying the
         *        appropriate byte range.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        After downloading all the parts of the job output, you have a list of eight checksum values. Compute
         *        the tree hash of these values to find the checksum of the entire output. Using the <a>DescribeJob</a>
         *        API, obtain job information of the job that provided you the output. The response includes the
         *        checksum of the entire archive stored in Amazon S3 Glacier. You compare this value with the checksum
         *        you computed to ensure you have downloaded the entire archive content with no errors.
         *        </p>
         *        <p/></li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(String range);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlacierRequest.BuilderImpl implements Builder {
        private String accountId;

        private String vaultName;

        private String jobId;

        private String range;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobOutputRequest model) {
            super(model);
            accountId(model.accountId);
            vaultName(model.vaultName);
            jobId(model.jobId);
            range(model.range);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getVaultName() {
            return vaultName;
        }

        public final void setVaultName(String vaultName) {
            this.vaultName = vaultName;
        }

        @Override
        public final Builder vaultName(String vaultName) {
            this.vaultName = vaultName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getRange() {
            return range;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetJobOutputRequest build() {
            return new GetJobOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
