/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glacier.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Amazon S3 Glacier response to your request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJobOutputResponse extends GlacierResponse implements
        ToCopyableBuilder<GetJobOutputResponse.Builder, GetJobOutputResponse> {
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checksum").getter(getter(GetJobOutputResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-sha256-tree-hash").build())
            .build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("status").getter(getter(GetJobOutputResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("status").build()).build();

    private static final SdkField<String> CONTENT_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentRange").getter(getter(GetJobOutputResponse::contentRange)).setter(setter(Builder::contentRange))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Range").build()).build();

    private static final SdkField<String> ACCEPT_RANGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("acceptRanges").getter(getter(GetJobOutputResponse::acceptRanges)).setter(setter(Builder::acceptRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept-Ranges").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetJobOutputResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> ARCHIVE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("archiveDescription").getter(getter(GetJobOutputResponse::archiveDescription))
            .setter(setter(Builder::archiveDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-archive-description").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_FIELD, STATUS_FIELD,
            CONTENT_RANGE_FIELD, ACCEPT_RANGES_FIELD, CONTENT_TYPE_FIELD, ARCHIVE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String checksum;

    private final Integer status;

    private final String contentRange;

    private final String acceptRanges;

    private final String contentType;

    private final String archiveDescription;

    private GetJobOutputResponse(BuilderImpl builder) {
        super(builder);
        this.checksum = builder.checksum;
        this.status = builder.status;
        this.contentRange = builder.contentRange;
        this.acceptRanges = builder.acceptRanges;
        this.contentType = builder.contentType;
        this.archiveDescription = builder.archiveDescription;
    }

    /**
     * <p>
     * The checksum of the data in the response. This header is returned only when retrieving the output for an archive
     * retrieval job. Furthermore, this header appears only under the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You get the entire range of the archive.
     * </p>
     * </li>
     * <li>
     * <p>
     * You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if you have
     * an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then the
     * x-amz-sha256-tree-hash is returned as a response header.
     * </p>
     * </li>
     * <li>
     * <p>
     * You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the
     * archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends at 3.1 MB
     * (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The checksum of the data in the response. This header is returned only when retrieving the output for an
     *         archive retrieval job. Furthermore, this header appears only under the following conditions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You get the entire range of the archive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if
     *         you have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then
     *         the x-amz-sha256-tree-hash is returned as a response header.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the
     *         archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends
     *         at 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.
     *         </p>
     *         </li>
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The HTTP response code for a job output request. The value depends on whether a range was specified in the
     * request.
     * </p>
     * 
     * @return The HTTP response code for a job output request. The value depends on whether a range was specified in
     *         the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response provides the
     * range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the first 1 MB from 8 MB.
     * </p>
     * 
     * @return The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response
     *         provides the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the
     *         first 1 MB from 8 MB.
     */
    public final String contentRange() {
        return contentRange;
    }

    /**
     * <p>
     * Indicates the range units accepted. For more information, see <a
     * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>.
     * </p>
     * 
     * @return Indicates the range units accepted. For more information, see <a
     *         href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>.
     */
    public final String acceptRanges() {
        return acceptRanges;
    }

    /**
     * <p>
     * The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data, the
     * Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you initiated the
     * job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as JSON, and the
     * Content-Type is application/json.
     * </p>
     * 
     * @return The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data,
     *         the Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you
     *         initiated the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as
     *         JSON, and the Content-Type is application/json.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The description of an archive.
     * </p>
     * 
     * @return The description of an archive.
     */
    public final String archiveDescription() {
        return archiveDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(acceptRanges());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(archiveDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobOutputResponse)) {
            return false;
        }
        GetJobOutputResponse other = (GetJobOutputResponse) obj;
        return Objects.equals(checksum(), other.checksum()) && Objects.equals(status(), other.status())
                && Objects.equals(contentRange(), other.contentRange()) && Objects.equals(acceptRanges(), other.acceptRanges())
                && Objects.equals(contentType(), other.contentType())
                && Objects.equals(archiveDescription(), other.archiveDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJobOutputResponse").add("Checksum", checksum()).add("Status", status())
                .add("ContentRange", contentRange()).add("AcceptRanges", acceptRanges()).add("ContentType", contentType())
                .add("ArchiveDescription", archiveDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "contentRange":
            return Optional.ofNullable(clazz.cast(contentRange()));
        case "acceptRanges":
            return Optional.ofNullable(clazz.cast(acceptRanges()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "archiveDescription":
            return Optional.ofNullable(clazz.cast(archiveDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-sha256-tree-hash", CHECKSUM_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("Content-Range", CONTENT_RANGE_FIELD);
        map.put("Accept-Ranges", ACCEPT_RANGES_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("x-amz-archive-description", ARCHIVE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJobOutputResponse, T> g) {
        return obj -> g.apply((GetJobOutputResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlacierResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetJobOutputResponse> {
        /**
         * <p>
         * The checksum of the data in the response. This header is returned only when retrieving the output for an
         * archive retrieval job. Furthermore, this header appears only under the following conditions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You get the entire range of the archive.
         * </p>
         * </li>
         * <li>
         * <p>
         * You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example, if you
         * have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB, then the
         * x-amz-sha256-tree-hash is returned as a response header.
         * </p>
         * </li>
         * <li>
         * <p>
         * You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of the
         * archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and ends at
         * 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response header.
         * </p>
         * </li>
         * </ul>
         * 
         * @param checksum
         *        The checksum of the data in the response. This header is returned only when retrieving the output for
         *        an archive retrieval job. Furthermore, this header appears only under the following conditions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        You get the entire range of the archive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You request a range to return of the archive that starts and ends on a multiple of 1 MB. For example,
         *        if you have an 3.1 MB archive and you specify a range to return that starts at 1 MB and ends at 2 MB,
         *        then the x-amz-sha256-tree-hash is returned as a response header.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You request a range of the archive to return that starts on a multiple of 1 MB and goes to the end of
         *        the archive. For example, if you have a 3.1 MB archive and you specify a range that starts at 2 MB and
         *        ends at 3.1 MB (the end of the archive), then the x-amz-sha256-tree-hash is returned as a response
         *        header.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The HTTP response code for a job output request. The value depends on whether a range was specified in the
         * request.
         * </p>
         * 
         * @param status
         *        The HTTP response code for a job output request. The value depends on whether a range was specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response provides
         * the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns the first 1 MB
         * from 8 MB.
         * </p>
         * 
         * @param contentRange
         *        The range of bytes returned by Amazon S3 Glacier. If only partial output is downloaded, the response
         *        provides the range of bytes Amazon S3 Glacier returned. For example, bytes 0-1048575/8388608 returns
         *        the first 1 MB from 8 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRange(String contentRange);

        /**
         * <p>
         * Indicates the range units accepted. For more information, see <a
         * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>.
         * </p>
         * 
         * @param acceptRanges
         *        Indicates the range units accepted. For more information, see <a
         *        href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html">RFC2616</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptRanges(String acceptRanges);

        /**
         * <p>
         * The Content-Type depends on whether the job output is an archive or a vault inventory. For archive data, the
         * Content-Type is application/octet-stream. For vault inventory, if you requested CSV format when you initiated
         * the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is returned as JSON, and the
         * Content-Type is application/json.
         * </p>
         * 
         * @param contentType
         *        The Content-Type depends on whether the job output is an archive or a vault inventory. For archive
         *        data, the Content-Type is application/octet-stream. For vault inventory, if you requested CSV format
         *        when you initiated the job, the Content-Type is text/csv. Otherwise, by default, vault inventory is
         *        returned as JSON, and the Content-Type is application/json.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The description of an archive.
         * </p>
         * 
         * @param archiveDescription
         *        The description of an archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveDescription(String archiveDescription);
    }

    static final class BuilderImpl extends GlacierResponse.BuilderImpl implements Builder {
        private String checksum;

        private Integer status;

        private String contentRange;

        private String acceptRanges;

        private String contentType;

        private String archiveDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobOutputResponse model) {
            super(model);
            checksum(model.checksum);
            status(model.status);
            contentRange(model.contentRange);
            acceptRanges(model.acceptRanges);
            contentType(model.contentType);
            archiveDescription(model.archiveDescription);
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getContentRange() {
            return contentRange;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final String getAcceptRanges() {
            return acceptRanges;
        }

        public final void setAcceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
        }

        @Override
        public final Builder acceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getArchiveDescription() {
            return archiveDescription;
        }

        public final void setArchiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
        }

        @Override
        public final Builder archiveDescription(String archiveDescription) {
            this.archiveDescription = archiveDescription;
            return this;
        }

        @Override
        public GetJobOutputResponse build() {
            return new GetJobOutputResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
