/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.model.Accelerator;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;

public class ListAcceleratorsPublisher
implements SdkPublisher<ListAcceleratorsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListAcceleratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAcceleratorsPublisher(GlobalAcceleratorAsyncClient client, ListAcceleratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAcceleratorsPublisher(GlobalAcceleratorAsyncClient client, ListAcceleratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAcceleratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAcceleratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Accelerator> accelerators() {
        Function<ListAcceleratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accelerators() != null) {
                return response.accelerators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAcceleratorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAcceleratorsResponseFetcher
    implements AsyncPageFetcher<ListAcceleratorsResponse> {
        private ListAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAcceleratorsResponse> nextPage(ListAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return ListAcceleratorsPublisher.this.client.listAccelerators(ListAcceleratorsPublisher.this.firstRequest);
            }
            return ListAcceleratorsPublisher.this.client.listAccelerators((ListAcceleratorsRequest)((Object)ListAcceleratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

