/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCrossAccountResourcesRequest
extends GlobalAcceleratorRequest
implements ToCopyableBuilder<Builder, ListCrossAccountResourcesRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceleratorArn").getter(ListCrossAccountResourcesRequest.getter(ListCrossAccountResourcesRequest::acceleratorArn)).setter(ListCrossAccountResourcesRequest.setter(Builder::acceleratorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceOwnerAwsAccountId").getter(ListCrossAccountResourcesRequest.getter(ListCrossAccountResourcesRequest::resourceOwnerAwsAccountId)).setter(ListCrossAccountResourcesRequest.setter(Builder::resourceOwnerAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceOwnerAwsAccountId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCrossAccountResourcesRequest.getter(ListCrossAccountResourcesRequest::maxResults)).setter(ListCrossAccountResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCrossAccountResourcesRequest.getter(ListCrossAccountResourcesRequest::nextToken)).setter(ListCrossAccountResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD, RESOURCE_OWNER_AWS_ACCOUNT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String acceleratorArn;
    private final String resourceOwnerAwsAccountId;
    private final Integer maxResults;
    private final String nextToken;

    private ListCrossAccountResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.resourceOwnerAwsAccountId = builder.resourceOwnerAwsAccountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String acceleratorArn() {
        return this.acceleratorArn;
    }

    public final String resourceOwnerAwsAccountId() {
        return this.resourceOwnerAwsAccountId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCrossAccountResourcesRequest)) {
            return false;
        }
        ListCrossAccountResourcesRequest other = (ListCrossAccountResourcesRequest)((Object)obj);
        return Objects.equals(this.acceleratorArn(), other.acceleratorArn()) && Objects.equals(this.resourceOwnerAwsAccountId(), other.resourceOwnerAwsAccountId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCrossAccountResourcesRequest").add("AcceleratorArn", (Object)this.acceleratorArn()).add("ResourceOwnerAwsAccountId", (Object)this.resourceOwnerAwsAccountId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorArn": {
                return Optional.ofNullable(clazz.cast(this.acceleratorArn()));
            }
            case "ResourceOwnerAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAwsAccountId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCrossAccountResourcesRequest, T> g) {
        return obj -> g.apply((ListCrossAccountResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlobalAcceleratorRequest.BuilderImpl
    implements Builder {
        private String acceleratorArn;
        private String resourceOwnerAwsAccountId;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCrossAccountResourcesRequest model) {
            super(model);
            this.acceleratorArn(model.acceleratorArn);
            this.resourceOwnerAwsAccountId(model.resourceOwnerAwsAccountId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAcceleratorArn() {
            return this.acceleratorArn;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final String getResourceOwnerAwsAccountId() {
            return this.resourceOwnerAwsAccountId;
        }

        public final void setResourceOwnerAwsAccountId(String resourceOwnerAwsAccountId) {
            this.resourceOwnerAwsAccountId = resourceOwnerAwsAccountId;
        }

        @Override
        public final Builder resourceOwnerAwsAccountId(String resourceOwnerAwsAccountId) {
            this.resourceOwnerAwsAccountId = resourceOwnerAwsAccountId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCrossAccountResourcesRequest build() {
            return new ListCrossAccountResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlobalAcceleratorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCrossAccountResourcesRequest> {
        public Builder acceleratorArn(String var1);

        public Builder resourceOwnerAwsAccountId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

