/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeletePartitionRequest extends GlueRequest implements
        ToCopyableBuilder<BatchDeletePartitionRequest.Builder, BatchDeletePartitionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(BatchDeletePartitionRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(BatchDeletePartitionRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(BatchDeletePartitionRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<List<PartitionValueList>> PARTITIONS_TO_DELETE_FIELD = SdkField
            .<List<PartitionValueList>> builder(MarshallingType.LIST)
            .memberName("PartitionsToDelete")
            .getter(getter(BatchDeletePartitionRequest::partitionsToDelete))
            .setter(setter(Builder::partitionsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionsToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PartitionValueList> builder(MarshallingType.SDK_POJO)
                                            .constructor(PartitionValueList::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, PARTITIONS_TO_DELETE_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final List<PartitionValueList> partitionsToDelete;

    private BatchDeletePartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionsToDelete = builder.partitionsToDelete;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS account ID is
     * used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS
     *         account ID is used by default.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database in which the table in question resides.
     * </p>
     * 
     * @return The name of the catalog database in which the table in question resides.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table that contains the partitions to be deleted.
     * </p>
     * 
     * @return The name of the table that contains the partitions to be deleted.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * Returns true if the PartitionsToDelete property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPartitionsToDelete() {
        return partitionsToDelete != null && !(partitionsToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitionsToDelete()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
     */
    public List<PartitionValueList> partitionsToDelete() {
        return partitionsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionsToDelete() ? partitionsToDelete() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePartitionRequest)) {
            return false;
        }
        BatchDeletePartitionRequest other = (BatchDeletePartitionRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && hasPartitionsToDelete() == other.hasPartitionsToDelete()
                && Objects.equals(partitionsToDelete(), other.partitionsToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchDeletePartitionRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("PartitionsToDelete", hasPartitionsToDelete() ? partitionsToDelete() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "PartitionsToDelete":
            return Optional.ofNullable(clazz.cast(partitionsToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePartitionRequest, T> g) {
        return obj -> g.apply((BatchDeletePartitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeletePartitionRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS account ID
         * is used by default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the partition to be deleted resides. If none is provided, the AWS
         *        account ID is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database in which the table in question resides.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database in which the table in question resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table that contains the partitions to be deleted.
         * </p>
         * 
         * @param tableName
         *        The name of the table that contains the partitions to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
         * </p>
         * 
         * @param partitionsToDelete
         *        A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionsToDelete(Collection<PartitionValueList> partitionsToDelete);

        /**
         * <p>
         * A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
         * </p>
         * 
         * @param partitionsToDelete
         *        A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionsToDelete(PartitionValueList... partitionsToDelete);

        /**
         * <p>
         * A list of <code>PartitionInput</code> structures that define the partitions to be deleted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PartitionValueList>.Builder} avoiding the
         * need to create one manually via {@link List<PartitionValueList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PartitionValueList>.Builder#build()} is called immediately
         * and its result is passed to {@link #partitionsToDelete(List<PartitionValueList>)}.
         * 
         * @param partitionsToDelete
         *        a consumer that will call methods on {@link List<PartitionValueList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionsToDelete(List<PartitionValueList>)
         */
        Builder partitionsToDelete(Consumer<PartitionValueList.Builder>... partitionsToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private List<PartitionValueList> partitionsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePartitionRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            partitionsToDelete(model.partitionsToDelete);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<PartitionValueList.Builder> getPartitionsToDelete() {
            if (partitionsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionsToDelete != null ? partitionsToDelete.stream().map(PartitionValueList::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder partitionsToDelete(Collection<PartitionValueList> partitionsToDelete) {
            this.partitionsToDelete = BatchDeletePartitionValueListCopier.copy(partitionsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionsToDelete(PartitionValueList... partitionsToDelete) {
            partitionsToDelete(Arrays.asList(partitionsToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionsToDelete(Consumer<PartitionValueList.Builder>... partitionsToDelete) {
            partitionsToDelete(Stream.of(partitionsToDelete).map(c -> PartitionValueList.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPartitionsToDelete(Collection<PartitionValueList.BuilderImpl> partitionsToDelete) {
            this.partitionsToDelete = BatchDeletePartitionValueListCopier.copyFromBuilder(partitionsToDelete);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeletePartitionRequest build() {
            return new BatchDeletePartitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
