/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetJobsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetJobsResponse.Builder, BatchGetJobsResponse> {
    private static final SdkField<List<Job>> JOBS_FIELD = SdkField
            .<List<Job>> builder(MarshallingType.LIST)
            .memberName("Jobs")
            .getter(getter(BatchGetJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Job> builder(MarshallingType.SDK_POJO)
                                            .constructor(Job::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> JOBS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("JobsNotFound")
            .getter(getter(BatchGetJobsResponse::jobsNotFound))
            .setter(setter(Builder::jobsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD,
            JOBS_NOT_FOUND_FIELD));

    private final List<Job> jobs;

    private final List<String> jobsNotFound;

    private BatchGetJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.jobsNotFound = builder.jobsNotFound;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of job definitions.
     */
    public List<Job> jobs() {
        return jobs;
    }

    /**
     * Returns true if the JobsNotFound property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobsNotFound() {
        return jobsNotFound != null && !(jobsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of jobs not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobsNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of names of jobs not found.
     */
    public List<String> jobsNotFound() {
        return jobsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobs() ? jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasJobsNotFound() ? jobsNotFound() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetJobsResponse)) {
            return false;
        }
        BatchGetJobsResponse other = (BatchGetJobsResponse) obj;
        return hasJobs() == other.hasJobs() && Objects.equals(jobs(), other.jobs())
                && hasJobsNotFound() == other.hasJobsNotFound() && Objects.equals(jobsNotFound(), other.jobsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetJobsResponse").add("Jobs", hasJobs() ? jobs() : null)
                .add("JobsNotFound", hasJobsNotFound() ? jobsNotFound() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        case "JobsNotFound":
            return Optional.ofNullable(clazz.cast(jobsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetJobsResponse, T> g) {
        return obj -> g.apply((BatchGetJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetJobsResponse> {
        /**
         * <p>
         * A list of job definitions.
         * </p>
         * 
         * @param jobs
         *        A list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<Job> jobs);

        /**
         * <p>
         * A list of job definitions.
         * </p>
         * 
         * @param jobs
         *        A list of job definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Job... jobs);

        /**
         * <p>
         * A list of job definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Job>.Builder} avoiding the need to create
         * one manually via {@link List<Job>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Job>.Builder#build()} is called immediately and its result
         * is passed to {@link #jobs(List<Job>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<Job>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<Job>)
         */
        Builder jobs(Consumer<Job.Builder>... jobs);

        /**
         * <p>
         * A list of names of jobs not found.
         * </p>
         * 
         * @param jobsNotFound
         *        A list of names of jobs not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobsNotFound(Collection<String> jobsNotFound);

        /**
         * <p>
         * A list of names of jobs not found.
         * </p>
         * 
         * @param jobsNotFound
         *        A list of names of jobs not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobsNotFound(String... jobsNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Job> jobs = DefaultSdkAutoConstructList.getInstance();

        private List<String> jobsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetJobsResponse model) {
            super(model);
            jobs(model.jobs);
            jobsNotFound(model.jobsNotFound);
        }

        public final Collection<Job.Builder> getJobs() {
            if (jobs instanceof SdkAutoConstructList) {
                return null;
            }
            return jobs != null ? jobs.stream().map(Job::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<Job> jobs) {
            this.jobs = JobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Job... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<Job.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> Job.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<Job.BuilderImpl> jobs) {
            this.jobs = JobListCopier.copyFromBuilder(jobs);
        }

        public final Collection<String> getJobsNotFound() {
            if (jobsNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return jobsNotFound;
        }

        @Override
        public final Builder jobsNotFound(Collection<String> jobsNotFound) {
            this.jobsNotFound = JobNameListCopier.copy(jobsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobsNotFound(String... jobsNotFound) {
            jobsNotFound(Arrays.asList(jobsNotFound));
            return this;
        }

        public final void setJobsNotFound(Collection<String> jobsNotFound) {
            this.jobsNotFound = JobNameListCopier.copy(jobsNotFound);
        }

        @Override
        public BatchGetJobsResponse build() {
            return new BatchGetJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
