/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a node in a directed acyclic graph (DAG)
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeGenNode implements SdkPojo, Serializable, ToCopyableBuilder<CodeGenNode.Builder, CodeGenNode> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(CodeGenNode::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(CodeGenNode::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<List<CodeGenNodeArg>> ARGS_FIELD = SdkField
            .<List<CodeGenNodeArg>> builder(MarshallingType.LIST)
            .memberName("Args")
            .getter(getter(CodeGenNode::args))
            .setter(setter(Builder::args))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Args").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeGenNodeArg> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeGenNodeArg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> LINE_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LineNumber").getter(getter(CodeGenNode::lineNumber)).setter(setter(Builder::lineNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NODE_TYPE_FIELD,
            ARGS_FIELD, LINE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String nodeType;

    private final List<CodeGenNodeArg> args;

    private final Integer lineNumber;

    private CodeGenNode(BuilderImpl builder) {
        this.id = builder.id;
        this.nodeType = builder.nodeType;
        this.args = builder.args;
        this.lineNumber = builder.lineNumber;
    }

    /**
     * <p>
     * A node identifier that is unique within the node's graph.
     * </p>
     * 
     * @return A node identifier that is unique within the node's graph.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The type of node that this is.
     * </p>
     * 
     * @return The type of node that this is.
     */
    public String nodeType() {
        return nodeType;
    }

    /**
     * Returns true if the Args property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArgs() {
        return args != null && !(args instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Properties of the node, in the form of name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArgs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Properties of the node, in the form of name-value pairs.
     */
    public List<CodeGenNodeArg> args() {
        return args;
    }

    /**
     * <p>
     * The line number of the node.
     * </p>
     * 
     * @return The line number of the node.
     */
    public Integer lineNumber() {
        return lineNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(hasArgs() ? args() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lineNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeGenNode)) {
            return false;
        }
        CodeGenNode other = (CodeGenNode) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(nodeType(), other.nodeType()) && hasArgs() == other.hasArgs()
                && Objects.equals(args(), other.args()) && Objects.equals(lineNumber(), other.lineNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CodeGenNode").add("Id", id()).add("NodeType", nodeType()).add("Args", hasArgs() ? args() : null)
                .add("LineNumber", lineNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "Args":
            return Optional.ofNullable(clazz.cast(args()));
        case "LineNumber":
            return Optional.ofNullable(clazz.cast(lineNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeGenNode, T> g) {
        return obj -> g.apply((CodeGenNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeGenNode> {
        /**
         * <p>
         * A node identifier that is unique within the node's graph.
         * </p>
         * 
         * @param id
         *        A node identifier that is unique within the node's graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of node that this is.
         * </p>
         * 
         * @param nodeType
         *        The type of node that this is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * Properties of the node, in the form of name-value pairs.
         * </p>
         * 
         * @param args
         *        Properties of the node, in the form of name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(Collection<CodeGenNodeArg> args);

        /**
         * <p>
         * Properties of the node, in the form of name-value pairs.
         * </p>
         * 
         * @param args
         *        Properties of the node, in the form of name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(CodeGenNodeArg... args);

        /**
         * <p>
         * Properties of the node, in the form of name-value pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeGenNodeArg>.Builder} avoiding the need
         * to create one manually via {@link List<CodeGenNodeArg>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeGenNodeArg>.Builder#build()} is called immediately and
         * its result is passed to {@link #args(List<CodeGenNodeArg>)}.
         * 
         * @param args
         *        a consumer that will call methods on {@link List<CodeGenNodeArg>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #args(List<CodeGenNodeArg>)
         */
        Builder args(Consumer<CodeGenNodeArg.Builder>... args);

        /**
         * <p>
         * The line number of the node.
         * </p>
         * 
         * @param lineNumber
         *        The line number of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineNumber(Integer lineNumber);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String nodeType;

        private List<CodeGenNodeArg> args = DefaultSdkAutoConstructList.getInstance();

        private Integer lineNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeGenNode model) {
            id(model.id);
            nodeType(model.nodeType);
            args(model.args);
            lineNumber(model.lineNumber);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getNodeType() {
            return nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Collection<CodeGenNodeArg.Builder> getArgs() {
            if (args instanceof SdkAutoConstructList) {
                return null;
            }
            return args != null ? args.stream().map(CodeGenNodeArg::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder args(Collection<CodeGenNodeArg> args) {
            this.args = CodeGenNodeArgsCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(CodeGenNodeArg... args) {
            args(Arrays.asList(args));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(Consumer<CodeGenNodeArg.Builder>... args) {
            args(Stream.of(args).map(c -> CodeGenNodeArg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArgs(Collection<CodeGenNodeArg.BuilderImpl> args) {
            this.args = CodeGenNodeArgsCopier.copyFromBuilder(args);
        }

        public final Integer getLineNumber() {
            return lineNumber;
        }

        @Override
        public final Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public final void setLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Override
        public CodeGenNode build() {
            return new CodeGenNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
