/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClassifierRequest extends GlueRequest implements
        ToCopyableBuilder<CreateClassifierRequest.Builder, CreateClassifierRequest> {
    private static final SdkField<CreateGrokClassifierRequest> GROK_CLASSIFIER_FIELD = SdkField
            .<CreateGrokClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("GrokClassifier")
            .getter(getter(CreateClassifierRequest::grokClassifier)).setter(setter(Builder::grokClassifier))
            .constructor(CreateGrokClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrokClassifier").build()).build();

    private static final SdkField<CreateXMLClassifierRequest> XML_CLASSIFIER_FIELD = SdkField
            .<CreateXMLClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("XMLClassifier")
            .getter(getter(CreateClassifierRequest::xmlClassifier)).setter(setter(Builder::xmlClassifier))
            .constructor(CreateXMLClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XMLClassifier").build()).build();

    private static final SdkField<CreateJsonClassifierRequest> JSON_CLASSIFIER_FIELD = SdkField
            .<CreateJsonClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("JsonClassifier")
            .getter(getter(CreateClassifierRequest::jsonClassifier)).setter(setter(Builder::jsonClassifier))
            .constructor(CreateJsonClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonClassifier").build()).build();

    private static final SdkField<CreateCsvClassifierRequest> CSV_CLASSIFIER_FIELD = SdkField
            .<CreateCsvClassifierRequest> builder(MarshallingType.SDK_POJO).memberName("CsvClassifier")
            .getter(getter(CreateClassifierRequest::csvClassifier)).setter(setter(Builder::csvClassifier))
            .constructor(CreateCsvClassifierRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvClassifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROK_CLASSIFIER_FIELD,
            XML_CLASSIFIER_FIELD, JSON_CLASSIFIER_FIELD, CSV_CLASSIFIER_FIELD));

    private final CreateGrokClassifierRequest grokClassifier;

    private final CreateXMLClassifierRequest xmlClassifier;

    private final CreateJsonClassifierRequest jsonClassifier;

    private final CreateCsvClassifierRequest csvClassifier;

    private CreateClassifierRequest(BuilderImpl builder) {
        super(builder);
        this.grokClassifier = builder.grokClassifier;
        this.xmlClassifier = builder.xmlClassifier;
        this.jsonClassifier = builder.jsonClassifier;
        this.csvClassifier = builder.csvClassifier;
    }

    /**
     * <p>
     * A <code>GrokClassifier</code> object specifying the classifier to create.
     * </p>
     * 
     * @return A <code>GrokClassifier</code> object specifying the classifier to create.
     */
    public CreateGrokClassifierRequest grokClassifier() {
        return grokClassifier;
    }

    /**
     * <p>
     * An <code>XMLClassifier</code> object specifying the classifier to create.
     * </p>
     * 
     * @return An <code>XMLClassifier</code> object specifying the classifier to create.
     */
    public CreateXMLClassifierRequest xmlClassifier() {
        return xmlClassifier;
    }

    /**
     * <p>
     * A <code>JsonClassifier</code> object specifying the classifier to create.
     * </p>
     * 
     * @return A <code>JsonClassifier</code> object specifying the classifier to create.
     */
    public CreateJsonClassifierRequest jsonClassifier() {
        return jsonClassifier;
    }

    /**
     * <p>
     * A <code>CsvClassifier</code> object specifying the classifier to create.
     * </p>
     * 
     * @return A <code>CsvClassifier</code> object specifying the classifier to create.
     */
    public CreateCsvClassifierRequest csvClassifier() {
        return csvClassifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(grokClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(xmlClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(jsonClassifier());
        hashCode = 31 * hashCode + Objects.hashCode(csvClassifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClassifierRequest)) {
            return false;
        }
        CreateClassifierRequest other = (CreateClassifierRequest) obj;
        return Objects.equals(grokClassifier(), other.grokClassifier()) && Objects.equals(xmlClassifier(), other.xmlClassifier())
                && Objects.equals(jsonClassifier(), other.jsonClassifier())
                && Objects.equals(csvClassifier(), other.csvClassifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateClassifierRequest").add("GrokClassifier", grokClassifier())
                .add("XMLClassifier", xmlClassifier()).add("JsonClassifier", jsonClassifier())
                .add("CsvClassifier", csvClassifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrokClassifier":
            return Optional.ofNullable(clazz.cast(grokClassifier()));
        case "XMLClassifier":
            return Optional.ofNullable(clazz.cast(xmlClassifier()));
        case "JsonClassifier":
            return Optional.ofNullable(clazz.cast(jsonClassifier()));
        case "CsvClassifier":
            return Optional.ofNullable(clazz.cast(csvClassifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClassifierRequest, T> g) {
        return obj -> g.apply((CreateClassifierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClassifierRequest> {
        /**
         * <p>
         * A <code>GrokClassifier</code> object specifying the classifier to create.
         * </p>
         * 
         * @param grokClassifier
         *        A <code>GrokClassifier</code> object specifying the classifier to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grokClassifier(CreateGrokClassifierRequest grokClassifier);

        /**
         * <p>
         * A <code>GrokClassifier</code> object specifying the classifier to create.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateGrokClassifierRequest.Builder} avoiding
         * the need to create one manually via {@link CreateGrokClassifierRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateGrokClassifierRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #grokClassifier(CreateGrokClassifierRequest)}.
         * 
         * @param grokClassifier
         *        a consumer that will call methods on {@link CreateGrokClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grokClassifier(CreateGrokClassifierRequest)
         */
        default Builder grokClassifier(Consumer<CreateGrokClassifierRequest.Builder> grokClassifier) {
            return grokClassifier(CreateGrokClassifierRequest.builder().applyMutation(grokClassifier).build());
        }

        /**
         * <p>
         * An <code>XMLClassifier</code> object specifying the classifier to create.
         * </p>
         * 
         * @param xmlClassifier
         *        An <code>XMLClassifier</code> object specifying the classifier to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xmlClassifier(CreateXMLClassifierRequest xmlClassifier);

        /**
         * <p>
         * An <code>XMLClassifier</code> object specifying the classifier to create.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateXMLClassifierRequest.Builder} avoiding the
         * need to create one manually via {@link CreateXMLClassifierRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateXMLClassifierRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #xmlClassifier(CreateXMLClassifierRequest)}.
         * 
         * @param xmlClassifier
         *        a consumer that will call methods on {@link CreateXMLClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xmlClassifier(CreateXMLClassifierRequest)
         */
        default Builder xmlClassifier(Consumer<CreateXMLClassifierRequest.Builder> xmlClassifier) {
            return xmlClassifier(CreateXMLClassifierRequest.builder().applyMutation(xmlClassifier).build());
        }

        /**
         * <p>
         * A <code>JsonClassifier</code> object specifying the classifier to create.
         * </p>
         * 
         * @param jsonClassifier
         *        A <code>JsonClassifier</code> object specifying the classifier to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonClassifier(CreateJsonClassifierRequest jsonClassifier);

        /**
         * <p>
         * A <code>JsonClassifier</code> object specifying the classifier to create.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateJsonClassifierRequest.Builder} avoiding
         * the need to create one manually via {@link CreateJsonClassifierRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateJsonClassifierRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #jsonClassifier(CreateJsonClassifierRequest)}.
         * 
         * @param jsonClassifier
         *        a consumer that will call methods on {@link CreateJsonClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jsonClassifier(CreateJsonClassifierRequest)
         */
        default Builder jsonClassifier(Consumer<CreateJsonClassifierRequest.Builder> jsonClassifier) {
            return jsonClassifier(CreateJsonClassifierRequest.builder().applyMutation(jsonClassifier).build());
        }

        /**
         * <p>
         * A <code>CsvClassifier</code> object specifying the classifier to create.
         * </p>
         * 
         * @param csvClassifier
         *        A <code>CsvClassifier</code> object specifying the classifier to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvClassifier(CreateCsvClassifierRequest csvClassifier);

        /**
         * <p>
         * A <code>CsvClassifier</code> object specifying the classifier to create.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateCsvClassifierRequest.Builder} avoiding the
         * need to create one manually via {@link CreateCsvClassifierRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateCsvClassifierRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #csvClassifier(CreateCsvClassifierRequest)}.
         * 
         * @param csvClassifier
         *        a consumer that will call methods on {@link CreateCsvClassifierRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #csvClassifier(CreateCsvClassifierRequest)
         */
        default Builder csvClassifier(Consumer<CreateCsvClassifierRequest.Builder> csvClassifier) {
            return csvClassifier(CreateCsvClassifierRequest.builder().applyMutation(csvClassifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private CreateGrokClassifierRequest grokClassifier;

        private CreateXMLClassifierRequest xmlClassifier;

        private CreateJsonClassifierRequest jsonClassifier;

        private CreateCsvClassifierRequest csvClassifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClassifierRequest model) {
            super(model);
            grokClassifier(model.grokClassifier);
            xmlClassifier(model.xmlClassifier);
            jsonClassifier(model.jsonClassifier);
            csvClassifier(model.csvClassifier);
        }

        public final CreateGrokClassifierRequest.Builder getGrokClassifier() {
            return grokClassifier != null ? grokClassifier.toBuilder() : null;
        }

        @Override
        public final Builder grokClassifier(CreateGrokClassifierRequest grokClassifier) {
            this.grokClassifier = grokClassifier;
            return this;
        }

        public final void setGrokClassifier(CreateGrokClassifierRequest.BuilderImpl grokClassifier) {
            this.grokClassifier = grokClassifier != null ? grokClassifier.build() : null;
        }

        public final CreateXMLClassifierRequest.Builder getXmlClassifier() {
            return xmlClassifier != null ? xmlClassifier.toBuilder() : null;
        }

        @Override
        public final Builder xmlClassifier(CreateXMLClassifierRequest xmlClassifier) {
            this.xmlClassifier = xmlClassifier;
            return this;
        }

        public final void setXmlClassifier(CreateXMLClassifierRequest.BuilderImpl xmlClassifier) {
            this.xmlClassifier = xmlClassifier != null ? xmlClassifier.build() : null;
        }

        public final CreateJsonClassifierRequest.Builder getJsonClassifier() {
            return jsonClassifier != null ? jsonClassifier.toBuilder() : null;
        }

        @Override
        public final Builder jsonClassifier(CreateJsonClassifierRequest jsonClassifier) {
            this.jsonClassifier = jsonClassifier;
            return this;
        }

        public final void setJsonClassifier(CreateJsonClassifierRequest.BuilderImpl jsonClassifier) {
            this.jsonClassifier = jsonClassifier != null ? jsonClassifier.build() : null;
        }

        public final CreateCsvClassifierRequest.Builder getCsvClassifier() {
            return csvClassifier != null ? csvClassifier.toBuilder() : null;
        }

        @Override
        public final Builder csvClassifier(CreateCsvClassifierRequest csvClassifier) {
            this.csvClassifier = csvClassifier;
            return this;
        }

        public final void setCsvClassifier(CreateCsvClassifierRequest.BuilderImpl csvClassifier) {
            this.csvClassifier = csvClassifier != null ? csvClassifier.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClassifierRequest build() {
            return new CreateClassifierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
