/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRegistryRequest extends GlueRequest implements
        ToCopyableBuilder<DeleteRegistryRequest.Builder, DeleteRegistryRequest> {
    private static final SdkField<RegistryId> REGISTRY_ID_FIELD = SdkField.<RegistryId> builder(MarshallingType.SDK_POJO)
            .memberName("RegistryId").getter(getter(DeleteRegistryRequest::registryId)).setter(setter(Builder::registryId))
            .constructor(RegistryId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD));

    private final RegistryId registryId;

    private DeleteRegistryRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
    }

    /**
     * <p>
     * This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
     * </p>
     * 
     * @return This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
     */
    public RegistryId registryId() {
        return registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRegistryRequest)) {
            return false;
        }
        DeleteRegistryRequest other = (DeleteRegistryRequest) obj;
        return Objects.equals(registryId(), other.registryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteRegistryRequest").add("RegistryId", registryId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRegistryRequest, T> g) {
        return obj -> g.apply((DeleteRegistryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRegistryRequest> {
        /**
         * <p>
         * This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
         * </p>
         * 
         * @param registryId
         *        This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(RegistryId registryId);

        /**
         * <p>
         * This is a wrapper structure that may contain the registry name and Amazon Resource Name (ARN).
         * </p>
         * This is a convenience that creates an instance of the {@link RegistryId.Builder} avoiding the need to create
         * one manually via {@link RegistryId#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegistryId.Builder#build()} is called immediately and its result
         * is passed to {@link #registryId(RegistryId)}.
         * 
         * @param registryId
         *        a consumer that will call methods on {@link RegistryId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryId(RegistryId)
         */
        default Builder registryId(Consumer<RegistryId.Builder> registryId) {
            return registryId(RegistryId.builder().applyMutation(registryId).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private RegistryId registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRegistryRequest model) {
            super(model);
            registryId(model.registryId);
        }

        public final RegistryId.Builder getRegistryId() {
            return registryId != null ? registryId.toBuilder() : null;
        }

        @Override
        public final Builder registryId(RegistryId registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(RegistryId.BuilderImpl registryId) {
            this.registryId = registryId != null ? registryId.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRegistryRequest build() {
            return new DeleteRegistryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
