/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An execution property of a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionProperty implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionProperty.Builder, ExecutionProperty> {
    private static final SdkField<Integer> MAX_CONCURRENT_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentRuns").getter(getter(ExecutionProperty::maxConcurrentRuns))
            .setter(setter(Builder::maxConcurrentRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentRuns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONCURRENT_RUNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxConcurrentRuns;

    private ExecutionProperty(BuilderImpl builder) {
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
    }

    /**
     * <p>
     * The maximum number of concurrent runs allowed for the job. The default is 1. An error is returned when this
     * threshold is reached. The maximum value you can specify is controlled by a service limit.
     * </p>
     * 
     * @return The maximum number of concurrent runs allowed for the job. The default is 1. An error is returned when
     *         this threshold is reached. The maximum value you can specify is controlled by a service limit.
     */
    public Integer maxConcurrentRuns() {
        return maxConcurrentRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentRuns());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionProperty)) {
            return false;
        }
        ExecutionProperty other = (ExecutionProperty) obj;
        return Objects.equals(maxConcurrentRuns(), other.maxConcurrentRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExecutionProperty").add("MaxConcurrentRuns", maxConcurrentRuns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxConcurrentRuns":
            return Optional.ofNullable(clazz.cast(maxConcurrentRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionProperty, T> g) {
        return obj -> g.apply((ExecutionProperty) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionProperty> {
        /**
         * <p>
         * The maximum number of concurrent runs allowed for the job. The default is 1. An error is returned when this
         * threshold is reached. The maximum value you can specify is controlled by a service limit.
         * </p>
         * 
         * @param maxConcurrentRuns
         *        The maximum number of concurrent runs allowed for the job. The default is 1. An error is returned when
         *        this threshold is reached. The maximum value you can specify is controlled by a service limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentRuns(Integer maxConcurrentRuns);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxConcurrentRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionProperty model) {
            maxConcurrentRuns(model.maxConcurrentRuns);
        }

        public final Integer getMaxConcurrentRuns() {
            return maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        @Override
        public ExecutionProperty build() {
            return new ExecutionProperty(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
