/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetClassifiersResponse extends GlueResponse implements
        ToCopyableBuilder<GetClassifiersResponse.Builder, GetClassifiersResponse> {
    private static final SdkField<List<Classifier>> CLASSIFIERS_FIELD = SdkField
            .<List<Classifier>> builder(MarshallingType.LIST)
            .memberName("Classifiers")
            .getter(getter(GetClassifiersResponse::classifiers))
            .setter(setter(Builder::classifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Classifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(Classifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetClassifiersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Classifier> classifiers;

    private final String nextToken;

    private GetClassifiersResponse(BuilderImpl builder) {
        super(builder);
        this.classifiers = builder.classifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Classifiers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClassifiers() {
        return classifiers != null && !(classifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The requested list of classifier objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClassifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The requested list of classifier objects.
     */
    public List<Classifier> classifiers() {
        return classifiers;
    }

    /**
     * <p>
     * A continuation token.
     * </p>
     * 
     * @return A continuation token.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasClassifiers() ? classifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClassifiersResponse)) {
            return false;
        }
        GetClassifiersResponse other = (GetClassifiersResponse) obj;
        return hasClassifiers() == other.hasClassifiers() && Objects.equals(classifiers(), other.classifiers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetClassifiersResponse").add("Classifiers", hasClassifiers() ? classifiers() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Classifiers":
            return Optional.ofNullable(clazz.cast(classifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClassifiersResponse, T> g) {
        return obj -> g.apply((GetClassifiersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetClassifiersResponse> {
        /**
         * <p>
         * The requested list of classifier objects.
         * </p>
         * 
         * @param classifiers
         *        The requested list of classifier objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiers(Collection<Classifier> classifiers);

        /**
         * <p>
         * The requested list of classifier objects.
         * </p>
         * 
         * @param classifiers
         *        The requested list of classifier objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classifiers(Classifier... classifiers);

        /**
         * <p>
         * The requested list of classifier objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Classifier>.Builder} avoiding the need to
         * create one manually via {@link List<Classifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Classifier>.Builder#build()} is called immediately and its
         * result is passed to {@link #classifiers(List<Classifier>)}.
         * 
         * @param classifiers
         *        a consumer that will call methods on {@link List<Classifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classifiers(List<Classifier>)
         */
        Builder classifiers(Consumer<Classifier.Builder>... classifiers);

        /**
         * <p>
         * A continuation token.
         * </p>
         * 
         * @param nextToken
         *        A continuation token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<Classifier> classifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClassifiersResponse model) {
            super(model);
            classifiers(model.classifiers);
            nextToken(model.nextToken);
        }

        public final Collection<Classifier.Builder> getClassifiers() {
            if (classifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return classifiers != null ? classifiers.stream().map(Classifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classifiers(Collection<Classifier> classifiers) {
            this.classifiers = ClassifierListCopier.copy(classifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(Classifier... classifiers) {
            classifiers(Arrays.asList(classifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifiers(Consumer<Classifier.Builder>... classifiers) {
            classifiers(Stream.of(classifiers).map(c -> Classifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setClassifiers(Collection<Classifier.BuilderImpl> classifiers) {
            this.classifiers = ClassifierListCopier.copyFromBuilder(classifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetClassifiersResponse build() {
            return new GetClassifiersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
