/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowRunsResponse extends GlueResponse implements
        ToCopyableBuilder<GetWorkflowRunsResponse.Builder, GetWorkflowRunsResponse> {
    private static final SdkField<List<WorkflowRun>> RUNS_FIELD = SdkField
            .<List<WorkflowRun>> builder(MarshallingType.LIST)
            .memberName("Runs")
            .getter(getter(GetWorkflowRunsResponse::runs))
            .setter(setter(Builder::runs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkflowRun> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowRun::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetWorkflowRunsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNS_FIELD, NEXT_TOKEN_FIELD));

    private final List<WorkflowRun> runs;

    private final String nextToken;

    private GetWorkflowRunsResponse(BuilderImpl builder) {
        super(builder);
        this.runs = builder.runs;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Runs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRuns() {
        return runs != null && !(runs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of workflow run metadata objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRuns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of workflow run metadata objects.
     */
    public List<WorkflowRun> runs() {
        return runs;
    }

    /**
     * <p>
     * A continuation token, if not all requested workflow runs have been returned.
     * </p>
     * 
     * @return A continuation token, if not all requested workflow runs have been returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRuns() ? runs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunsResponse)) {
            return false;
        }
        GetWorkflowRunsResponse other = (GetWorkflowRunsResponse) obj;
        return hasRuns() == other.hasRuns() && Objects.equals(runs(), other.runs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetWorkflowRunsResponse").add("Runs", hasRuns() ? runs() : null).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Runs":
            return Optional.ofNullable(clazz.cast(runs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunsResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowRunsResponse> {
        /**
         * <p>
         * A list of workflow run metadata objects.
         * </p>
         * 
         * @param runs
         *        A list of workflow run metadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(Collection<WorkflowRun> runs);

        /**
         * <p>
         * A list of workflow run metadata objects.
         * </p>
         * 
         * @param runs
         *        A list of workflow run metadata objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runs(WorkflowRun... runs);

        /**
         * <p>
         * A list of workflow run metadata objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkflowRun>.Builder} avoiding the need to
         * create one manually via {@link List<WorkflowRun>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkflowRun>.Builder#build()} is called immediately and its
         * result is passed to {@link #runs(List<WorkflowRun>)}.
         * 
         * @param runs
         *        a consumer that will call methods on {@link List<WorkflowRun>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runs(List<WorkflowRun>)
         */
        Builder runs(Consumer<WorkflowRun.Builder>... runs);

        /**
         * <p>
         * A continuation token, if not all requested workflow runs have been returned.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if not all requested workflow runs have been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<WorkflowRun> runs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunsResponse model) {
            super(model);
            runs(model.runs);
            nextToken(model.nextToken);
        }

        public final Collection<WorkflowRun.Builder> getRuns() {
            if (runs instanceof SdkAutoConstructList) {
                return null;
            }
            return runs != null ? runs.stream().map(WorkflowRun::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runs(Collection<WorkflowRun> runs) {
            this.runs = WorkflowRunsCopier.copy(runs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(WorkflowRun... runs) {
            runs(Arrays.asList(runs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runs(Consumer<WorkflowRun.Builder>... runs) {
            runs(Stream.of(runs).map(c -> WorkflowRun.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRuns(Collection<WorkflowRun.BuilderImpl> runs) {
            this.runs = WorkflowRunsCopier.copyFromBuilder(runs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetWorkflowRunsResponse build() {
            return new GetWorkflowRunsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
