/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status and error information about the most recent crawl.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastCrawlInfo implements SdkPojo, Serializable, ToCopyableBuilder<LastCrawlInfo.Builder, LastCrawlInfo> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LastCrawlInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(LastCrawlInfo::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroup").getter(getter(LastCrawlInfo::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()).build();

    private static final SdkField<String> LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogStream").getter(getter(LastCrawlInfo::logStream)).setter(setter(Builder::logStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStream").build()).build();

    private static final SdkField<String> MESSAGE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessagePrefix").getter(getter(LastCrawlInfo::messagePrefix)).setter(setter(Builder::messagePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessagePrefix").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(LastCrawlInfo::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            ERROR_MESSAGE_FIELD, LOG_GROUP_FIELD, LOG_STREAM_FIELD, MESSAGE_PREFIX_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String errorMessage;

    private final String logGroup;

    private final String logStream;

    private final String messagePrefix;

    private final Instant startTime;

    private LastCrawlInfo(BuilderImpl builder) {
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.logGroup = builder.logGroup;
        this.logStream = builder.logStream;
        this.messagePrefix = builder.messagePrefix;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * Status of the last crawl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastCrawlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the last crawl.
     * @see LastCrawlStatus
     */
    public LastCrawlStatus status() {
        return LastCrawlStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the last crawl.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastCrawlStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the last crawl.
     * @see LastCrawlStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, the error information about the last crawl.
     * </p>
     * 
     * @return If an error occurred, the error information about the last crawl.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The log group for the last crawl.
     * </p>
     * 
     * @return The log group for the last crawl.
     */
    public String logGroup() {
        return logGroup;
    }

    /**
     * <p>
     * The log stream for the last crawl.
     * </p>
     * 
     * @return The log stream for the last crawl.
     */
    public String logStream() {
        return logStream;
    }

    /**
     * <p>
     * The prefix for a message about this crawl.
     * </p>
     * 
     * @return The prefix for a message about this crawl.
     */
    public String messagePrefix() {
        return messagePrefix;
    }

    /**
     * <p>
     * The time at which the crawl started.
     * </p>
     * 
     * @return The time at which the crawl started.
     */
    public Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(logStream());
        hashCode = 31 * hashCode + Objects.hashCode(messagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastCrawlInfo)) {
            return false;
        }
        LastCrawlInfo other = (LastCrawlInfo) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(logGroup(), other.logGroup()) && Objects.equals(logStream(), other.logStream())
                && Objects.equals(messagePrefix(), other.messagePrefix()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LastCrawlInfo").add("Status", statusAsString()).add("ErrorMessage", errorMessage())
                .add("LogGroup", logGroup()).add("LogStream", logStream()).add("MessagePrefix", messagePrefix())
                .add("StartTime", startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "LogGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        case "LogStream":
            return Optional.ofNullable(clazz.cast(logStream()));
        case "MessagePrefix":
            return Optional.ofNullable(clazz.cast(messagePrefix()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LastCrawlInfo, T> g) {
        return obj -> g.apply((LastCrawlInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastCrawlInfo> {
        /**
         * <p>
         * Status of the last crawl.
         * </p>
         * 
         * @param status
         *        Status of the last crawl.
         * @see LastCrawlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastCrawlStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the last crawl.
         * </p>
         * 
         * @param status
         *        Status of the last crawl.
         * @see LastCrawlStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastCrawlStatus
         */
        Builder status(LastCrawlStatus status);

        /**
         * <p>
         * If an error occurred, the error information about the last crawl.
         * </p>
         * 
         * @param errorMessage
         *        If an error occurred, the error information about the last crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The log group for the last crawl.
         * </p>
         * 
         * @param logGroup
         *        The log group for the last crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);

        /**
         * <p>
         * The log stream for the last crawl.
         * </p>
         * 
         * @param logStream
         *        The log stream for the last crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStream(String logStream);

        /**
         * <p>
         * The prefix for a message about this crawl.
         * </p>
         * 
         * @param messagePrefix
         *        The prefix for a message about this crawl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messagePrefix(String messagePrefix);

        /**
         * <p>
         * The time at which the crawl started.
         * </p>
         * 
         * @param startTime
         *        The time at which the crawl started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String errorMessage;

        private String logGroup;

        private String logStream;

        private String messagePrefix;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LastCrawlInfo model) {
            status(model.status);
            errorMessage(model.errorMessage);
            logGroup(model.logGroup);
            logStream(model.logStream);
            messagePrefix(model.messagePrefix);
            startTime(model.startTime);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LastCrawlStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getLogGroup() {
            return logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final String getLogStream() {
            return logStream;
        }

        @Override
        public final Builder logStream(String logStream) {
            this.logStream = logStream;
            return this;
        }

        public final void setLogStream(String logStream) {
            this.logStream = logStream;
        }

        public final String getMessagePrefix() {
            return messagePrefix;
        }

        @Override
        public final Builder messagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            return this;
        }

        public final void setMessagePrefix(String messagePrefix) {
            this.messagePrefix = messagePrefix;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public LastCrawlInfo build() {
            return new LastCrawlInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
