/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaVersionNumber implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaVersionNumber.Builder, SchemaVersionNumber> {
    private static final SdkField<Boolean> LATEST_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LatestVersion").getter(getter(SchemaVersionNumber::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersion").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(SchemaVersionNumber::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_VERSION_FIELD,
            VERSION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean latestVersion;

    private final Long versionNumber;

    private SchemaVersionNumber(BuilderImpl builder) {
        this.latestVersion = builder.latestVersion;
        this.versionNumber = builder.versionNumber;
    }

    /**
     * Returns the value of the LatestVersion property for this object.
     * 
     * @return The value of the LatestVersion property for this object.
     */
    public Boolean latestVersion() {
        return latestVersion;
    }

    /**
     * Returns the value of the VersionNumber property for this object.
     * 
     * @return The value of the VersionNumber property for this object.
     */
    public Long versionNumber() {
        return versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaVersionNumber)) {
            return false;
        }
        SchemaVersionNumber other = (SchemaVersionNumber) obj;
        return Objects.equals(latestVersion(), other.latestVersion()) && Objects.equals(versionNumber(), other.versionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SchemaVersionNumber").add("LatestVersion", latestVersion())
                .add("VersionNumber", versionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LatestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaVersionNumber, T> g) {
        return obj -> g.apply((SchemaVersionNumber) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaVersionNumber> {
        /**
         * Sets the value of the LatestVersion property for this object.
         *
         * @param latestVersion
         *        The new value for the LatestVersion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Boolean latestVersion);

        /**
         * Sets the value of the VersionNumber property for this object.
         *
         * @param versionNumber
         *        The new value for the VersionNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);
    }

    static final class BuilderImpl implements Builder {
        private Boolean latestVersion;

        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaVersionNumber model) {
            latestVersion(model.latestVersion);
            versionNumber(model.versionNumber);
        }

        public final Boolean getLatestVersion() {
            return latestVersion;
        }

        @Override
        public final Builder latestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final void setLatestVersion(Boolean latestVersion) {
            this.latestVersion = latestVersion;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public SchemaVersionNumber build() {
            return new SchemaVersionNumber(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
