/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCrawlerScheduleRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateCrawlerScheduleRequest.Builder, UpdateCrawlerScheduleRequest> {
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CrawlerName").getter(getter(UpdateCrawlerScheduleRequest::crawlerName))
            .setter(setter(Builder::crawlerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(UpdateCrawlerScheduleRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAME_FIELD,
            SCHEDULE_FIELD));

    private final String crawlerName;

    private final String schedule;

    private UpdateCrawlerScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.crawlerName = builder.crawlerName;
        this.schedule = builder.schedule;
    }

    /**
     * <p>
     * The name of the crawler whose schedule to update.
     * </p>
     * 
     * @return The name of the crawler whose schedule to update.
     */
    public String crawlerName() {
        return crawlerName;
    }

    /**
     * <p>
     * The updated <code>cron</code> expression used to specify the schedule (see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules for
     * Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
     * <code>cron(15 12 * * ? *)</code>.
     * </p>
     * 
     * @return The updated <code>cron</code> expression used to specify the schedule (see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
     *         Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
     *         specify: <code>cron(15 12 * * ? *)</code>.
     */
    public String schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrawlerScheduleRequest)) {
            return false;
        }
        UpdateCrawlerScheduleRequest other = (UpdateCrawlerScheduleRequest) obj;
        return Objects.equals(crawlerName(), other.crawlerName()) && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCrawlerScheduleRequest").add("CrawlerName", crawlerName()).add("Schedule", schedule())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerName":
            return Optional.ofNullable(clazz.cast(crawlerName()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCrawlerScheduleRequest, T> g) {
        return obj -> g.apply((UpdateCrawlerScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCrawlerScheduleRequest> {
        /**
         * <p>
         * The name of the crawler whose schedule to update.
         * </p>
         * 
         * @param crawlerName
         *        The name of the crawler whose schedule to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerName(String crawlerName);

        /**
         * <p>
         * The updated <code>cron</code> expression used to specify the schedule (see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based Schedules
         * for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would specify:
         * <code>cron(15 12 * * ? *)</code>.
         * </p>
         * 
         * @param schedule
         *        The updated <code>cron</code> expression used to specify the schedule (see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
         *        Schedules for Jobs and Crawlers</a>. For example, to run something every day at 12:15 UTC, you would
         *        specify: <code>cron(15 12 * * ? *)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String crawlerName;

        private String schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrawlerScheduleRequest model) {
            super(model);
            crawlerName(model.crawlerName);
            schedule(model.schedule);
        }

        public final String getCrawlerName() {
            return crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrawlerScheduleRequest build() {
            return new UpdateCrawlerScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
