/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutDataQualityStatisticAnnotationResponse extends GlueResponse implements
        ToCopyableBuilder<BatchPutDataQualityStatisticAnnotationResponse.Builder, BatchPutDataQualityStatisticAnnotationResponse> {
    private static final SdkField<List<AnnotationError>> FAILED_INCLUSION_ANNOTATIONS_FIELD = SdkField
            .<List<AnnotationError>> builder(MarshallingType.LIST)
            .memberName("FailedInclusionAnnotations")
            .getter(getter(BatchPutDataQualityStatisticAnnotationResponse::failedInclusionAnnotations))
            .setter(setter(Builder::failedInclusionAnnotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedInclusionAnnotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnnotationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnnotationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FAILED_INCLUSION_ANNOTATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AnnotationError> failedInclusionAnnotations;

    private BatchPutDataQualityStatisticAnnotationResponse(BuilderImpl builder) {
        super(builder);
        this.failedInclusionAnnotations = builder.failedInclusionAnnotations;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedInclusionAnnotations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFailedInclusionAnnotations() {
        return failedInclusionAnnotations != null && !(failedInclusionAnnotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AnnotationError</code>'s.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedInclusionAnnotations} method.
     * </p>
     * 
     * @return A list of <code>AnnotationError</code>'s.
     */
    public final List<AnnotationError> failedInclusionAnnotations() {
        return failedInclusionAnnotations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedInclusionAnnotations() ? failedInclusionAnnotations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDataQualityStatisticAnnotationResponse)) {
            return false;
        }
        BatchPutDataQualityStatisticAnnotationResponse other = (BatchPutDataQualityStatisticAnnotationResponse) obj;
        return hasFailedInclusionAnnotations() == other.hasFailedInclusionAnnotations()
                && Objects.equals(failedInclusionAnnotations(), other.failedInclusionAnnotations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutDataQualityStatisticAnnotationResponse")
                .add("FailedInclusionAnnotations", hasFailedInclusionAnnotations() ? failedInclusionAnnotations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedInclusionAnnotations":
            return Optional.ofNullable(clazz.cast(failedInclusionAnnotations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedInclusionAnnotations", FAILED_INCLUSION_ANNOTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDataQualityStatisticAnnotationResponse, T> g) {
        return obj -> g.apply((BatchPutDataQualityStatisticAnnotationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchPutDataQualityStatisticAnnotationResponse> {
        /**
         * <p>
         * A list of <code>AnnotationError</code>'s.
         * </p>
         * 
         * @param failedInclusionAnnotations
         *        A list of <code>AnnotationError</code>'s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedInclusionAnnotations(Collection<AnnotationError> failedInclusionAnnotations);

        /**
         * <p>
         * A list of <code>AnnotationError</code>'s.
         * </p>
         * 
         * @param failedInclusionAnnotations
         *        A list of <code>AnnotationError</code>'s.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedInclusionAnnotations(AnnotationError... failedInclusionAnnotations);

        /**
         * <p>
         * A list of <code>AnnotationError</code>'s.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.AnnotationError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.AnnotationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.AnnotationError.Builder#build()} is called immediately and
         * its result is passed to {@link #failedInclusionAnnotations(List<AnnotationError>)}.
         * 
         * @param failedInclusionAnnotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.AnnotationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedInclusionAnnotations(java.util.Collection<AnnotationError>)
         */
        Builder failedInclusionAnnotations(Consumer<AnnotationError.Builder>... failedInclusionAnnotations);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<AnnotationError> failedInclusionAnnotations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDataQualityStatisticAnnotationResponse model) {
            super(model);
            failedInclusionAnnotations(model.failedInclusionAnnotations);
        }

        public final List<AnnotationError.Builder> getFailedInclusionAnnotations() {
            List<AnnotationError.Builder> result = AnnotationErrorListCopier.copyToBuilder(this.failedInclusionAnnotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedInclusionAnnotations(Collection<AnnotationError.BuilderImpl> failedInclusionAnnotations) {
            this.failedInclusionAnnotations = AnnotationErrorListCopier.copyFromBuilder(failedInclusionAnnotations);
        }

        @Override
        public final Builder failedInclusionAnnotations(Collection<AnnotationError> failedInclusionAnnotations) {
            this.failedInclusionAnnotations = AnnotationErrorListCopier.copy(failedInclusionAnnotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedInclusionAnnotations(AnnotationError... failedInclusionAnnotations) {
            failedInclusionAnnotations(Arrays.asList(failedInclusionAnnotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedInclusionAnnotations(Consumer<AnnotationError.Builder>... failedInclusionAnnotations) {
            failedInclusionAnnotations(Stream.of(failedInclusionAnnotations)
                    .map(c -> AnnotationError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutDataQualityStatisticAnnotationResponse build() {
            return new BatchPutDataQualityStatisticAnnotationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
