/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlTransformResponse extends GlueResponse implements
        ToCopyableBuilder<GetMlTransformResponse.Builder, GetMlTransformResponse> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformId").getter(getter(GetMlTransformResponse::transformId)).setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetMlTransformResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetMlTransformResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetMlTransformResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedOn").getter(getter(GetMlTransformResponse::createdOn)).setter(setter(Builder::createdOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(GetMlTransformResponse::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<List<GlueTable>> INPUT_RECORD_TABLES_FIELD = SdkField
            .<List<GlueTable>> builder(MarshallingType.LIST)
            .memberName("InputRecordTables")
            .getter(getter(GetMlTransformResponse::inputRecordTables))
            .setter(setter(Builder::inputRecordTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputRecordTables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlueTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlueTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TransformParameters> PARAMETERS_FIELD = SdkField
            .<TransformParameters> builder(MarshallingType.SDK_POJO).memberName("Parameters")
            .getter(getter(GetMlTransformResponse::parameters)).setter(setter(Builder::parameters))
            .constructor(TransformParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<EvaluationMetrics> EVALUATION_METRICS_FIELD = SdkField
            .<EvaluationMetrics> builder(MarshallingType.SDK_POJO).memberName("EvaluationMetrics")
            .getter(getter(GetMlTransformResponse::evaluationMetrics)).setter(setter(Builder::evaluationMetrics))
            .constructor(EvaluationMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMetrics").build()).build();

    private static final SdkField<Integer> LABEL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LabelCount").getter(getter(GetMlTransformResponse::labelCount)).setter(setter(Builder::labelCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCount").build()).build();

    private static final SdkField<List<SchemaColumn>> SCHEMA_FIELD = SdkField
            .<List<SchemaColumn>> builder(MarshallingType.LIST)
            .memberName("Schema")
            .getter(getter(GetMlTransformResponse::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GetMlTransformResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlueVersion").getter(getter(GetMlTransformResponse::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MaxCapacity").getter(getter(GetMlTransformResponse::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkerType").getter(getter(GetMlTransformResponse::workerTypeAsString))
            .setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(GetMlTransformResponse::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(GetMlTransformResponse::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRetries").getter(getter(GetMlTransformResponse::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final SdkField<TransformEncryption> TRANSFORM_ENCRYPTION_FIELD = SdkField
            .<TransformEncryption> builder(MarshallingType.SDK_POJO).memberName("TransformEncryption")
            .getter(getter(GetMlTransformResponse::transformEncryption)).setter(setter(Builder::transformEncryption))
            .constructor(TransformEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEncryption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, INPUT_RECORD_TABLES_FIELD,
            PARAMETERS_FIELD, EVALUATION_METRICS_FIELD, LABEL_COUNT_FIELD, SCHEMA_FIELD, ROLE_FIELD, GLUE_VERSION_FIELD,
            MAX_CAPACITY_FIELD, WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, MAX_RETRIES_FIELD,
            TRANSFORM_ENCRYPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transformId;

    private final String name;

    private final String description;

    private final String status;

    private final Instant createdOn;

    private final Instant lastModifiedOn;

    private final List<GlueTable> inputRecordTables;

    private final TransformParameters parameters;

    private final EvaluationMetrics evaluationMetrics;

    private final Integer labelCount;

    private final List<SchemaColumn> schema;

    private final String role;

    private final String glueVersion;

    private final Double maxCapacity;

    private final String workerType;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final Integer maxRetries;

    private final TransformEncryption transformEncryption;

    private GetMlTransformResponse(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.inputRecordTables = builder.inputRecordTables;
        this.parameters = builder.parameters;
        this.evaluationMetrics = builder.evaluationMetrics;
        this.labelCount = builder.labelCount;
        this.schema = builder.schema;
        this.role = builder.role;
        this.glueVersion = builder.glueVersion;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
        this.transformEncryption = builder.transformEncryption;
    }

    /**
     * <p>
     * The unique identifier of the transform, generated at the time that the transform was created.
     * </p>
     * 
     * @return The unique identifier of the transform, generated at the time that the transform was created.
     */
    public final String transformId() {
        return transformId;
    }

    /**
     * <p>
     * The unique name given to the transform when it was created.
     * </p>
     * 
     * @return The unique name given to the transform when it was created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the transform.
     * </p>
     * 
     * @return A description of the transform.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY",
     * or "DELETING".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY",
     *         "READY", or "DELETING".
     * @see TransformStatusType
     */
    public final TransformStatusType status() {
        return TransformStatusType.fromValue(status);
    }

    /**
     * <p>
     * The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY", "READY",
     * or "DELETING".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TransformStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY",
     *         "READY", or "DELETING".
     * @see TransformStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the transform was created.
     * </p>
     * 
     * @return The date and time when the transform was created.
     */
    public final Instant createdOn() {
        return createdOn;
    }

    /**
     * <p>
     * The date and time when the transform was last modified.
     * </p>
     * 
     * @return The date and time when the transform was last modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputRecordTables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputRecordTables() {
        return inputRecordTables != null && !(inputRecordTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Glue table definitions used by the transform.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputRecordTables} method.
     * </p>
     * 
     * @return A list of Glue table definitions used by the transform.
     */
    public final List<GlueTable> inputRecordTables() {
        return inputRecordTables;
    }

    /**
     * <p>
     * The configuration parameters that are specific to the algorithm used.
     * </p>
     * 
     * @return The configuration parameters that are specific to the algorithm used.
     */
    public final TransformParameters parameters() {
        return parameters;
    }

    /**
     * <p>
     * The latest evaluation metrics.
     * </p>
     * 
     * @return The latest evaluation metrics.
     */
    public final EvaluationMetrics evaluationMetrics() {
        return evaluationMetrics;
    }

    /**
     * <p>
     * The number of labels available for this transform.
     * </p>
     * 
     * @return The number of labels available for this transform.
     */
    public final Integer labelCount() {
        return labelCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Schema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchema() {
        return schema != null && !(schema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts. Has an
     * upper bound of 100 columns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchema} method.
     * </p>
     * 
     * @return The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts.
     *         Has an upper bound of 100 columns.
     */
    public final List<SchemaColumn> schema() {
        return schema;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a> in
     * the developer guide.
     * </p>
     * 
     * @return This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0
     *         is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue
     *         Versions</a> in the developer guide.
     */
    public final String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
     * </p>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @return The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You
     *         can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that
     *         consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *         href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>. </p>
     *         <p>
     *         When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *         <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */
    public final Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public final String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this
     * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is
     * 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a task run for this transform in minutes. This is the maximum time that a task run for
     *         this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The
     *         default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The maximum number of times to retry a task for this transform after a task run fails.
     * </p>
     * 
     * @return The maximum number of times to retry a task for this transform after a task run fails.
     */
    public final Integer maxRetries() {
        return maxRetries;
    }

    /**
     * <p>
     * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning transforms
     * can access user data encrypted in Amazon S3 using KMS.
     * </p>
     * 
     * @return The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
     *         transforms can access user data encrypted in Amazon S3 using KMS.
     */
    public final TransformEncryption transformEncryption() {
        return transformEncryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputRecordTables() ? inputRecordTables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(labelCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasSchema() ? schema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        hashCode = 31 * hashCode + Objects.hashCode(transformEncryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTransformResponse)) {
            return false;
        }
        GetMlTransformResponse other = (GetMlTransformResponse) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdOn(), other.createdOn()) && Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && hasInputRecordTables() == other.hasInputRecordTables()
                && Objects.equals(inputRecordTables(), other.inputRecordTables())
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(evaluationMetrics(), other.evaluationMetrics())
                && Objects.equals(labelCount(), other.labelCount()) && hasSchema() == other.hasSchema()
                && Objects.equals(schema(), other.schema()) && Objects.equals(role(), other.role())
                && Objects.equals(glueVersion(), other.glueVersion()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(maxRetries(), other.maxRetries())
                && Objects.equals(transformEncryption(), other.transformEncryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlTransformResponse").add("TransformId", transformId()).add("Name", name())
                .add("Description", description()).add("Status", statusAsString()).add("CreatedOn", createdOn())
                .add("LastModifiedOn", lastModifiedOn())
                .add("InputRecordTables", hasInputRecordTables() ? inputRecordTables() : null).add("Parameters", parameters())
                .add("EvaluationMetrics", evaluationMetrics()).add("LabelCount", labelCount())
                .add("Schema", hasSchema() ? schema() : null).add("Role", role()).add("GlueVersion", glueVersion())
                .add("MaxCapacity", maxCapacity()).add("WorkerType", workerTypeAsString())
                .add("NumberOfWorkers", numberOfWorkers()).add("Timeout", timeout()).add("MaxRetries", maxRetries())
                .add("TransformEncryption", transformEncryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedOn":
            return Optional.ofNullable(clazz.cast(createdOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "InputRecordTables":
            return Optional.ofNullable(clazz.cast(inputRecordTables()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "EvaluationMetrics":
            return Optional.ofNullable(clazz.cast(evaluationMetrics()));
        case "LabelCount":
            return Optional.ofNullable(clazz.cast(labelCount()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        case "TransformEncryption":
            return Optional.ofNullable(clazz.cast(transformEncryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransformId", TRANSFORM_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedOn", CREATED_ON_FIELD);
        map.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
        map.put("InputRecordTables", INPUT_RECORD_TABLES_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("EvaluationMetrics", EVALUATION_METRICS_FIELD);
        map.put("LabelCount", LABEL_COUNT_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("GlueVersion", GLUE_VERSION_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("WorkerType", WORKER_TYPE_FIELD);
        map.put("NumberOfWorkers", NUMBER_OF_WORKERS_FIELD);
        map.put("Timeout", TIMEOUT_FIELD);
        map.put("MaxRetries", MAX_RETRIES_FIELD);
        map.put("TransformEncryption", TRANSFORM_ENCRYPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlTransformResponse, T> g) {
        return obj -> g.apply((GetMlTransformResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlTransformResponse> {
        /**
         * <p>
         * The unique identifier of the transform, generated at the time that the transform was created.
         * </p>
         * 
         * @param transformId
         *        The unique identifier of the transform, generated at the time that the transform was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * The unique name given to the transform when it was created.
         * </p>
         * 
         * @param name
         *        The unique name given to the transform when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the transform.
         * </p>
         * 
         * @param description
         *        A description of the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY",
         * "READY", or "DELETING".
         * </p>
         * 
         * @param status
         *        The last known status of the transform (to indicate whether it can be used or not). One of
         *        "NOT_READY", "READY", or "DELETING".
         * @see TransformStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The last known status of the transform (to indicate whether it can be used or not). One of "NOT_READY",
         * "READY", or "DELETING".
         * </p>
         * 
         * @param status
         *        The last known status of the transform (to indicate whether it can be used or not). One of
         *        "NOT_READY", "READY", or "DELETING".
         * @see TransformStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransformStatusType
         */
        Builder status(TransformStatusType status);

        /**
         * <p>
         * The date and time when the transform was created.
         * </p>
         * 
         * @param createdOn
         *        The date and time when the transform was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdOn(Instant createdOn);

        /**
         * <p>
         * The date and time when the transform was last modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        The date and time when the transform was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * A list of Glue table definitions used by the transform.
         * </p>
         * 
         * @param inputRecordTables
         *        A list of Glue table definitions used by the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecordTables(Collection<GlueTable> inputRecordTables);

        /**
         * <p>
         * A list of Glue table definitions used by the transform.
         * </p>
         * 
         * @param inputRecordTables
         *        A list of Glue table definitions used by the transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecordTables(GlueTable... inputRecordTables);

        /**
         * <p>
         * A list of Glue table definitions used by the transform.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.GlueTable.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.glue.model.GlueTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.GlueTable.Builder#build()} is called immediately and its
         * result is passed to {@link #inputRecordTables(List<GlueTable>)}.
         * 
         * @param inputRecordTables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.GlueTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputRecordTables(java.util.Collection<GlueTable>)
         */
        Builder inputRecordTables(Consumer<GlueTable.Builder>... inputRecordTables);

        /**
         * <p>
         * The configuration parameters that are specific to the algorithm used.
         * </p>
         * 
         * @param parameters
         *        The configuration parameters that are specific to the algorithm used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TransformParameters parameters);

        /**
         * <p>
         * The configuration parameters that are specific to the algorithm used.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformParameters.Builder} avoiding the
         * need to create one manually via {@link TransformParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(TransformParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link TransformParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(TransformParameters)
         */
        default Builder parameters(Consumer<TransformParameters.Builder> parameters) {
            return parameters(TransformParameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * The latest evaluation metrics.
         * </p>
         * 
         * @param evaluationMetrics
         *        The latest evaluation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationMetrics(EvaluationMetrics evaluationMetrics);

        /**
         * <p>
         * The latest evaluation metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationMetrics.Builder} avoiding the
         * need to create one manually via {@link EvaluationMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #evaluationMetrics(EvaluationMetrics)}.
         * 
         * @param evaluationMetrics
         *        a consumer that will call methods on {@link EvaluationMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationMetrics(EvaluationMetrics)
         */
        default Builder evaluationMetrics(Consumer<EvaluationMetrics.Builder> evaluationMetrics) {
            return evaluationMetrics(EvaluationMetrics.builder().applyMutation(evaluationMetrics).build());
        }

        /**
         * <p>
         * The number of labels available for this transform.
         * </p>
         * 
         * @param labelCount
         *        The number of labels available for this transform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCount(Integer labelCount);

        /**
         * <p>
         * The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts. Has
         * an upper bound of 100 columns.
         * </p>
         * 
         * @param schema
         *        The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform
         *        accepts. Has an upper bound of 100 columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Collection<SchemaColumn> schema);

        /**
         * <p>
         * The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts. Has
         * an upper bound of 100 columns.
         * </p>
         * 
         * @param schema
         *        The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform
         *        accepts. Has an upper bound of 100 columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(SchemaColumn... schema);

        /**
         * <p>
         * The <code>Map&lt;Column, Type&gt;</code> object that represents the schema that this transform accepts. Has
         * an upper bound of 100 columns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.SchemaColumn.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.SchemaColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.SchemaColumn.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(List<SchemaColumn>)}.
         * 
         * @param schema
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.SchemaColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(java.util.Collection<SchemaColumn>)
         */
        Builder schema(Consumer<SchemaColumn.Builder>... schema);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
         * </p>
         * 
         * @param role
         *        The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * This value determines which version of Glue this machine learning transform is compatible with. Glue 1.0 is
         * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue Versions</a>
         * in the developer guide.
         * </p>
         * 
         * @param glueVersion
         *        This value determines which version of Glue this machine learning transform is compatible with. Glue
         *        1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to
         *        Glue 0.9. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">Glue
         *        Versions</a> in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
         * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists
         * of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
         * href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>.
         * </p>
         * <p>
         * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         * <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * </p>
         * 
         * @param maxCapacity
         *        The number of Glue data processing units (DPUs) that are allocated to task runs for this transform.
         *        You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing
         *        power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the
         *        <a href="https://aws.amazon.com/glue/pricing/">Glue pricing page</a>. </p>
         *        <p>
         *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this
         * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
         * is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a task run for this transform in minutes. This is the maximum time that a task run for
         *        this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status.
         *        The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The maximum number of times to retry a task for this transform after a task run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry a task for this transform after a task run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        /**
         * <p>
         * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * </p>
         * 
         * @param transformEncryption
         *        The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         *        transforms can access user data encrypted in Amazon S3 using KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformEncryption(TransformEncryption transformEncryption);

        /**
         * <p>
         * The encryption-at-rest settings of the transform that apply to accessing user data. Machine learning
         * transforms can access user data encrypted in Amazon S3 using KMS.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformEncryption.Builder} avoiding the
         * need to create one manually via {@link TransformEncryption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformEncryption.Builder#build()} is called immediately and
         * its result is passed to {@link #transformEncryption(TransformEncryption)}.
         * 
         * @param transformEncryption
         *        a consumer that will call methods on {@link TransformEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformEncryption(TransformEncryption)
         */
        default Builder transformEncryption(Consumer<TransformEncryption.Builder> transformEncryption) {
            return transformEncryption(TransformEncryption.builder().applyMutation(transformEncryption).build());
        }
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String transformId;

        private String name;

        private String description;

        private String status;

        private Instant createdOn;

        private Instant lastModifiedOn;

        private List<GlueTable> inputRecordTables = DefaultSdkAutoConstructList.getInstance();

        private TransformParameters parameters;

        private EvaluationMetrics evaluationMetrics;

        private Integer labelCount;

        private List<SchemaColumn> schema = DefaultSdkAutoConstructList.getInstance();

        private String role;

        private String glueVersion;

        private Double maxCapacity;

        private String workerType;

        private Integer numberOfWorkers;

        private Integer timeout;

        private Integer maxRetries;

        private TransformEncryption transformEncryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTransformResponse model) {
            super(model);
            transformId(model.transformId);
            name(model.name);
            description(model.description);
            status(model.status);
            createdOn(model.createdOn);
            lastModifiedOn(model.lastModifiedOn);
            inputRecordTables(model.inputRecordTables);
            parameters(model.parameters);
            evaluationMetrics(model.evaluationMetrics);
            labelCount(model.labelCount);
            schema(model.schema);
            role(model.role);
            glueVersion(model.glueVersion);
            maxCapacity(model.maxCapacity);
            workerType(model.workerType);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            maxRetries(model.maxRetries);
            transformEncryption(model.transformEncryption);
        }

        public final String getTransformId() {
            return transformId;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TransformStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedOn() {
            return createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final List<GlueTable.Builder> getInputRecordTables() {
            List<GlueTable.Builder> result = GlueTablesCopier.copyToBuilder(this.inputRecordTables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputRecordTables(Collection<GlueTable.BuilderImpl> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copyFromBuilder(inputRecordTables);
        }

        @Override
        public final Builder inputRecordTables(Collection<GlueTable> inputRecordTables) {
            this.inputRecordTables = GlueTablesCopier.copy(inputRecordTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(GlueTable... inputRecordTables) {
            inputRecordTables(Arrays.asList(inputRecordTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputRecordTables(Consumer<GlueTable.Builder>... inputRecordTables) {
            inputRecordTables(Stream.of(inputRecordTables).map(c -> GlueTable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TransformParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(TransformParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(TransformParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final EvaluationMetrics.Builder getEvaluationMetrics() {
            return evaluationMetrics != null ? evaluationMetrics.toBuilder() : null;
        }

        public final void setEvaluationMetrics(EvaluationMetrics.BuilderImpl evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics != null ? evaluationMetrics.build() : null;
        }

        @Override
        public final Builder evaluationMetrics(EvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public final Integer getLabelCount() {
            return labelCount;
        }

        public final void setLabelCount(Integer labelCount) {
            this.labelCount = labelCount;
        }

        @Override
        public final Builder labelCount(Integer labelCount) {
            this.labelCount = labelCount;
            return this;
        }

        public final List<SchemaColumn.Builder> getSchema() {
            List<SchemaColumn.Builder> result = TransformSchemaCopier.copyToBuilder(this.schema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchema(Collection<SchemaColumn.BuilderImpl> schema) {
            this.schema = TransformSchemaCopier.copyFromBuilder(schema);
        }

        @Override
        public final Builder schema(Collection<SchemaColumn> schema) {
            this.schema = TransformSchemaCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(SchemaColumn... schema) {
            schema(Arrays.asList(schema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schema(Consumer<SchemaColumn.Builder>... schema) {
            schema(Stream.of(schema).map(c -> SchemaColumn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final String getWorkerType() {
            return workerType;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final TransformEncryption.Builder getTransformEncryption() {
            return transformEncryption != null ? transformEncryption.toBuilder() : null;
        }

        public final void setTransformEncryption(TransformEncryption.BuilderImpl transformEncryption) {
            this.transformEncryption = transformEncryption != null ? transformEncryption.build() : null;
        }

        @Override
        public final Builder transformEncryption(TransformEncryption transformEncryption) {
            this.transformEncryption = transformEncryption;
            return this;
        }

        @Override
        public GetMlTransformResponse build() {
            return new GetMlTransformResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
