/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines a connection type for a compute environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Property implements SdkPojo, Serializable, ToCopyableBuilder<Property.Builder, Property> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Property::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Property::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Required").getter(getter(Property::required)).setter(setter(Builder::required))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Required").build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(Property::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<List<String>> PROPERTY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PropertyTypes")
            .getter(getter(Property::propertyTypesAsStrings))
            .setter(setter(Builder::propertyTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AllowedValue>> ALLOWED_VALUES_FIELD = SdkField
            .<List<AllowedValue>> builder(MarshallingType.LIST)
            .memberName("AllowedValues")
            .getter(getter(Property::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AllowedValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AllowedValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DATA_OPERATION_SCOPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DataOperationScopes")
            .getter(getter(Property::dataOperationScopesAsStrings))
            .setter(setter(Builder::dataOperationScopesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOperationScopes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            REQUIRED_FIELD, DEFAULT_VALUE_FIELD, PROPERTY_TYPES_FIELD, ALLOWED_VALUES_FIELD, DATA_OPERATION_SCOPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final Boolean required;

    private final String defaultValue;

    private final List<String> propertyTypes;

    private final List<AllowedValue> allowedValues;

    private final List<String> dataOperationScopes;

    private Property(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.required = builder.required;
        this.defaultValue = builder.defaultValue;
        this.propertyTypes = builder.propertyTypes;
        this.allowedValues = builder.allowedValues;
        this.dataOperationScopes = builder.dataOperationScopes;
    }

    /**
     * <p>
     * The name of the property.
     * </p>
     * 
     * @return The name of the property.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the property.
     * </p>
     * 
     * @return A description of the property.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Indicates whether the property is required.
     * </p>
     * 
     * @return Indicates whether the property is required.
     */
    public final Boolean required() {
        return required;
    }

    /**
     * <p>
     * The default value for the property.
     * </p>
     * 
     * @return The default value for the property.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * Describes the type of property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyTypes} method.
     * </p>
     * 
     * @return Describes the type of property.
     */
    public final List<PropertyType> propertyTypes() {
        return PropertyTypesCopier.copyStringToEnum(propertyTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropertyTypes() {
        return propertyTypes != null && !(propertyTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the type of property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyTypes} method.
     * </p>
     * 
     * @return Describes the type of property.
     */
    public final List<String> propertyTypesAsStrings() {
        return propertyTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>AllowedValue</code> objects representing the values allowed for the property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedValues} method.
     * </p>
     * 
     * @return A list of <code>AllowedValue</code> objects representing the values allowed for the property.
     */
    public final List<AllowedValue> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * Indicates which data operations are applicable to the property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataOperationScopes} method.
     * </p>
     * 
     * @return Indicates which data operations are applicable to the property.
     */
    public final List<DataOperation> dataOperationScopes() {
        return DataOperationsCopier.copyStringToEnum(dataOperationScopes);
    }

    /**
     * For responses, this returns true if the service returned a value for the DataOperationScopes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataOperationScopes() {
        return dataOperationScopes != null && !(dataOperationScopes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which data operations are applicable to the property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataOperationScopes} method.
     * </p>
     * 
     * @return Indicates which data operations are applicable to the property.
     */
    public final List<String> dataOperationScopesAsStrings() {
        return dataOperationScopes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(required());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropertyTypes() ? propertyTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedValues() ? allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataOperationScopes() ? dataOperationScopesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        Property other = (Property) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(required(), other.required()) && Objects.equals(defaultValue(), other.defaultValue())
                && hasPropertyTypes() == other.hasPropertyTypes()
                && Objects.equals(propertyTypesAsStrings(), other.propertyTypesAsStrings())
                && hasAllowedValues() == other.hasAllowedValues() && Objects.equals(allowedValues(), other.allowedValues())
                && hasDataOperationScopes() == other.hasDataOperationScopes()
                && Objects.equals(dataOperationScopesAsStrings(), other.dataOperationScopesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Property").add("Name", name()).add("Description", description()).add("Required", required())
                .add("DefaultValue", defaultValue()).add("PropertyTypes", hasPropertyTypes() ? propertyTypesAsStrings() : null)
                .add("AllowedValues", hasAllowedValues() ? allowedValues() : null)
                .add("DataOperationScopes", hasDataOperationScopes() ? dataOperationScopesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Required":
            return Optional.ofNullable(clazz.cast(required()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "PropertyTypes":
            return Optional.ofNullable(clazz.cast(propertyTypesAsStrings()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "DataOperationScopes":
            return Optional.ofNullable(clazz.cast(dataOperationScopesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Required", REQUIRED_FIELD);
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("PropertyTypes", PROPERTY_TYPES_FIELD);
        map.put("AllowedValues", ALLOWED_VALUES_FIELD);
        map.put("DataOperationScopes", DATA_OPERATION_SCOPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Property, T> g) {
        return obj -> g.apply((Property) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Property> {
        /**
         * <p>
         * The name of the property.
         * </p>
         * 
         * @param name
         *        The name of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the property.
         * </p>
         * 
         * @param description
         *        A description of the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Indicates whether the property is required.
         * </p>
         * 
         * @param required
         *        Indicates whether the property is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder required(Boolean required);

        /**
         * <p>
         * The default value for the property.
         * </p>
         * 
         * @param defaultValue
         *        The default value for the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * Describes the type of property.
         * </p>
         * 
         * @param propertyTypes
         *        Describes the type of property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyTypesWithStrings(Collection<String> propertyTypes);

        /**
         * <p>
         * Describes the type of property.
         * </p>
         * 
         * @param propertyTypes
         *        Describes the type of property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyTypesWithStrings(String... propertyTypes);

        /**
         * <p>
         * Describes the type of property.
         * </p>
         * 
         * @param propertyTypes
         *        Describes the type of property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyTypes(Collection<PropertyType> propertyTypes);

        /**
         * <p>
         * Describes the type of property.
         * </p>
         * 
         * @param propertyTypes
         *        Describes the type of property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyTypes(PropertyType... propertyTypes);

        /**
         * <p>
         * A list of <code>AllowedValue</code> objects representing the values allowed for the property.
         * </p>
         * 
         * @param allowedValues
         *        A list of <code>AllowedValue</code> objects representing the values allowed for the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<AllowedValue> allowedValues);

        /**
         * <p>
         * A list of <code>AllowedValue</code> objects representing the values allowed for the property.
         * </p>
         * 
         * @param allowedValues
         *        A list of <code>AllowedValue</code> objects representing the values allowed for the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(AllowedValue... allowedValues);

        /**
         * <p>
         * A list of <code>AllowedValue</code> objects representing the values allowed for the property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.AllowedValue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.AllowedValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.AllowedValue.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedValues(List<AllowedValue>)}.
         * 
         * @param allowedValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.AllowedValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedValues(java.util.Collection<AllowedValue>)
         */
        Builder allowedValues(Consumer<AllowedValue.Builder>... allowedValues);

        /**
         * <p>
         * Indicates which data operations are applicable to the property.
         * </p>
         * 
         * @param dataOperationScopes
         *        Indicates which data operations are applicable to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOperationScopesWithStrings(Collection<String> dataOperationScopes);

        /**
         * <p>
         * Indicates which data operations are applicable to the property.
         * </p>
         * 
         * @param dataOperationScopes
         *        Indicates which data operations are applicable to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOperationScopesWithStrings(String... dataOperationScopes);

        /**
         * <p>
         * Indicates which data operations are applicable to the property.
         * </p>
         * 
         * @param dataOperationScopes
         *        Indicates which data operations are applicable to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOperationScopes(Collection<DataOperation> dataOperationScopes);

        /**
         * <p>
         * Indicates which data operations are applicable to the property.
         * </p>
         * 
         * @param dataOperationScopes
         *        Indicates which data operations are applicable to the property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOperationScopes(DataOperation... dataOperationScopes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private Boolean required;

        private String defaultValue;

        private List<String> propertyTypes = DefaultSdkAutoConstructList.getInstance();

        private List<AllowedValue> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> dataOperationScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Property model) {
            name(model.name);
            description(model.description);
            required(model.required);
            defaultValue(model.defaultValue);
            propertyTypesWithStrings(model.propertyTypes);
            allowedValues(model.allowedValues);
            dataOperationScopesWithStrings(model.dataOperationScopes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getRequired() {
            return required;
        }

        public final void setRequired(Boolean required) {
            this.required = required;
        }

        @Override
        public final Builder required(Boolean required) {
            this.required = required;
            return this;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Collection<String> getPropertyTypes() {
            if (propertyTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return propertyTypes;
        }

        public final void setPropertyTypes(Collection<String> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copy(propertyTypes);
        }

        @Override
        public final Builder propertyTypesWithStrings(Collection<String> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copy(propertyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyTypesWithStrings(String... propertyTypes) {
            propertyTypesWithStrings(Arrays.asList(propertyTypes));
            return this;
        }

        @Override
        public final Builder propertyTypes(Collection<PropertyType> propertyTypes) {
            this.propertyTypes = PropertyTypesCopier.copyEnumToString(propertyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyTypes(PropertyType... propertyTypes) {
            propertyTypes(Arrays.asList(propertyTypes));
            return this;
        }

        public final List<AllowedValue.Builder> getAllowedValues() {
            List<AllowedValue.Builder> result = AllowedValuesCopier.copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<AllowedValue.BuilderImpl> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copyFromBuilder(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<AllowedValue> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(AllowedValue... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(Consumer<AllowedValue.Builder>... allowedValues) {
            allowedValues(Stream.of(allowedValues).map(c -> AllowedValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDataOperationScopes() {
            if (dataOperationScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return dataOperationScopes;
        }

        public final void setDataOperationScopes(Collection<String> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copy(dataOperationScopes);
        }

        @Override
        public final Builder dataOperationScopesWithStrings(Collection<String> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copy(dataOperationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataOperationScopesWithStrings(String... dataOperationScopes) {
            dataOperationScopesWithStrings(Arrays.asList(dataOperationScopes));
            return this;
        }

        @Override
        public final Builder dataOperationScopes(Collection<DataOperation> dataOperationScopes) {
            this.dataOperationScopes = DataOperationsCopier.copyEnumToString(dataOperationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataOperationScopes(DataOperation... dataOperationScopes) {
            dataOperationScopes(Arrays.asList(dataOperationScopes));
            return this;
        }

        @Override
        public Property build() {
            return new Property(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
