/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties used by the target leg to partition the data on the target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetTableConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetTableConfig.Builder, TargetTableConfig> {
    private static final SdkField<String> UNNEST_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnnestSpec").getter(getter(TargetTableConfig::unnestSpecAsString)).setter(setter(Builder::unnestSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnnestSpec").build()).build();

    private static final SdkField<List<IntegrationPartition>> PARTITION_SPEC_FIELD = SdkField
            .<List<IntegrationPartition>> builder(MarshallingType.LIST)
            .memberName("PartitionSpec")
            .getter(getter(TargetTableConfig::partitionSpec))
            .setter(setter(Builder::partitionSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionSpec").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IntegrationPartition> builder(MarshallingType.SDK_POJO)
                                            .constructor(IntegrationPartition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetTableName").getter(getter(TargetTableConfig::targetTableName))
            .setter(setter(Builder::targetTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNNEST_SPEC_FIELD,
            PARTITION_SPEC_FIELD, TARGET_TABLE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String unnestSpec;

    private final List<IntegrationPartition> partitionSpec;

    private final String targetTableName;

    private TargetTableConfig(BuilderImpl builder) {
        this.unnestSpec = builder.unnestSpec;
        this.partitionSpec = builder.partitionSpec;
        this.targetTableName = builder.targetTableName;
    }

    /**
     * <p>
     * Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL", or
     * "NOUNNEST".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unnestSpec} will
     * return {@link UnnestSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unnestSpecAsString}.
     * </p>
     * 
     * @return Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL",
     *         or "NOUNNEST".
     * @see UnnestSpec
     */
    public final UnnestSpec unnestSpec() {
        return UnnestSpec.fromValue(unnestSpec);
    }

    /**
     * <p>
     * Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL", or
     * "NOUNNEST".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unnestSpec} will
     * return {@link UnnestSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unnestSpecAsString}.
     * </p>
     * 
     * @return Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL",
     *         or "NOUNNEST".
     * @see UnnestSpec
     */
    public final String unnestSpecAsString() {
        return unnestSpec;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionSpec property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionSpec() {
        return partitionSpec != null && !(partitionSpec instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the file layout on the target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionSpec} method.
     * </p>
     * 
     * @return Determines the file layout on the target.
     */
    public final List<IntegrationPartition> partitionSpec() {
        return partitionSpec;
    }

    /**
     * <p>
     * The optional name of a target table.
     * </p>
     * 
     * @return The optional name of a target table.
     */
    public final String targetTableName() {
        return targetTableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unnestSpecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionSpec() ? partitionSpec() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetTableName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTableConfig)) {
            return false;
        }
        TargetTableConfig other = (TargetTableConfig) obj;
        return Objects.equals(unnestSpecAsString(), other.unnestSpecAsString()) && hasPartitionSpec() == other.hasPartitionSpec()
                && Objects.equals(partitionSpec(), other.partitionSpec())
                && Objects.equals(targetTableName(), other.targetTableName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetTableConfig").add("UnnestSpec", unnestSpecAsString())
                .add("PartitionSpec", hasPartitionSpec() ? partitionSpec() : null).add("TargetTableName", targetTableName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnnestSpec":
            return Optional.ofNullable(clazz.cast(unnestSpecAsString()));
        case "PartitionSpec":
            return Optional.ofNullable(clazz.cast(partitionSpec()));
        case "TargetTableName":
            return Optional.ofNullable(clazz.cast(targetTableName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UnnestSpec", UNNEST_SPEC_FIELD);
        map.put("PartitionSpec", PARTITION_SPEC_FIELD);
        map.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetTableConfig, T> g) {
        return obj -> g.apply((TargetTableConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetTableConfig> {
        /**
         * <p>
         * Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL", or
         * "NOUNNEST".
         * </p>
         * 
         * @param unnestSpec
         *        Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL",
         *        "FULL", or "NOUNNEST".
         * @see UnnestSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnnestSpec
         */
        Builder unnestSpec(String unnestSpec);

        /**
         * <p>
         * Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL", "FULL", or
         * "NOUNNEST".
         * </p>
         * 
         * @param unnestSpec
         *        Specifies how nested objects are flattened to top-level elements. Valid values are: "TOPLEVEL",
         *        "FULL", or "NOUNNEST".
         * @see UnnestSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UnnestSpec
         */
        Builder unnestSpec(UnnestSpec unnestSpec);

        /**
         * <p>
         * Determines the file layout on the target.
         * </p>
         * 
         * @param partitionSpec
         *        Determines the file layout on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSpec(Collection<IntegrationPartition> partitionSpec);

        /**
         * <p>
         * Determines the file layout on the target.
         * </p>
         * 
         * @param partitionSpec
         *        Determines the file layout on the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionSpec(IntegrationPartition... partitionSpec);

        /**
         * <p>
         * Determines the file layout on the target.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.IntegrationPartition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.IntegrationPartition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.IntegrationPartition.Builder#build()} is called immediately
         * and its result is passed to {@link #partitionSpec(List<IntegrationPartition>)}.
         * 
         * @param partitionSpec
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.IntegrationPartition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionSpec(java.util.Collection<IntegrationPartition>)
         */
        Builder partitionSpec(Consumer<IntegrationPartition.Builder>... partitionSpec);

        /**
         * <p>
         * The optional name of a target table.
         * </p>
         * 
         * @param targetTableName
         *        The optional name of a target table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableName(String targetTableName);
    }

    static final class BuilderImpl implements Builder {
        private String unnestSpec;

        private List<IntegrationPartition> partitionSpec = DefaultSdkAutoConstructList.getInstance();

        private String targetTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTableConfig model) {
            unnestSpec(model.unnestSpec);
            partitionSpec(model.partitionSpec);
            targetTableName(model.targetTableName);
        }

        public final String getUnnestSpec() {
            return unnestSpec;
        }

        public final void setUnnestSpec(String unnestSpec) {
            this.unnestSpec = unnestSpec;
        }

        @Override
        public final Builder unnestSpec(String unnestSpec) {
            this.unnestSpec = unnestSpec;
            return this;
        }

        @Override
        public final Builder unnestSpec(UnnestSpec unnestSpec) {
            this.unnestSpec(unnestSpec == null ? null : unnestSpec.toString());
            return this;
        }

        public final List<IntegrationPartition.Builder> getPartitionSpec() {
            List<IntegrationPartition.Builder> result = IntegrationPartitionSpecListCopier.copyToBuilder(this.partitionSpec);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionSpec(Collection<IntegrationPartition.BuilderImpl> partitionSpec) {
            this.partitionSpec = IntegrationPartitionSpecListCopier.copyFromBuilder(partitionSpec);
        }

        @Override
        public final Builder partitionSpec(Collection<IntegrationPartition> partitionSpec) {
            this.partitionSpec = IntegrationPartitionSpecListCopier.copy(partitionSpec);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSpec(IntegrationPartition... partitionSpec) {
            partitionSpec(Arrays.asList(partitionSpec));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSpec(Consumer<IntegrationPartition.Builder>... partitionSpec) {
            partitionSpec(Stream.of(partitionSpec).map(c -> IntegrationPartition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTargetTableName() {
            return targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        @Override
        public TargetTableConfig build() {
            return new TargetTableConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
