/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A timestamp filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampFilter implements SdkPojo, Serializable, ToCopyableBuilder<TimestampFilter.Builder, TimestampFilter> {
    private static final SdkField<Instant> RECORDED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecordedBefore").getter(getter(TimestampFilter::recordedBefore)).setter(setter(Builder::recordedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedBefore").build()).build();

    private static final SdkField<Instant> RECORDED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RecordedAfter").getter(getter(TimestampFilter::recordedAfter)).setter(setter(Builder::recordedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordedAfter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDED_BEFORE_FIELD,
            RECORDED_AFTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant recordedBefore;

    private final Instant recordedAfter;

    private TimestampFilter(BuilderImpl builder) {
        this.recordedBefore = builder.recordedBefore;
        this.recordedAfter = builder.recordedAfter;
    }

    /**
     * <p>
     * The timestamp before which statistics should be included in the results.
     * </p>
     * 
     * @return The timestamp before which statistics should be included in the results.
     */
    public final Instant recordedBefore() {
        return recordedBefore;
    }

    /**
     * <p>
     * The timestamp after which statistics should be included in the results.
     * </p>
     * 
     * @return The timestamp after which statistics should be included in the results.
     */
    public final Instant recordedAfter() {
        return recordedAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(recordedAfter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampFilter)) {
            return false;
        }
        TimestampFilter other = (TimestampFilter) obj;
        return Objects.equals(recordedBefore(), other.recordedBefore()) && Objects.equals(recordedAfter(), other.recordedAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampFilter").add("RecordedBefore", recordedBefore()).add("RecordedAfter", recordedAfter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordedBefore":
            return Optional.ofNullable(clazz.cast(recordedBefore()));
        case "RecordedAfter":
            return Optional.ofNullable(clazz.cast(recordedAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordedBefore", RECORDED_BEFORE_FIELD);
        map.put("RecordedAfter", RECORDED_AFTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestampFilter, T> g) {
        return obj -> g.apply((TimestampFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampFilter> {
        /**
         * <p>
         * The timestamp before which statistics should be included in the results.
         * </p>
         * 
         * @param recordedBefore
         *        The timestamp before which statistics should be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordedBefore(Instant recordedBefore);

        /**
         * <p>
         * The timestamp after which statistics should be included in the results.
         * </p>
         * 
         * @param recordedAfter
         *        The timestamp after which statistics should be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordedAfter(Instant recordedAfter);
    }

    static final class BuilderImpl implements Builder {
        private Instant recordedBefore;

        private Instant recordedAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampFilter model) {
            recordedBefore(model.recordedBefore);
            recordedAfter(model.recordedAfter);
        }

        public final Instant getRecordedBefore() {
            return recordedBefore;
        }

        public final void setRecordedBefore(Instant recordedBefore) {
            this.recordedBefore = recordedBefore;
        }

        @Override
        public final Builder recordedBefore(Instant recordedBefore) {
            this.recordedBefore = recordedBefore;
            return this;
        }

        public final Instant getRecordedAfter() {
            return recordedAfter;
        }

        public final void setRecordedAfter(Instant recordedAfter) {
            this.recordedAfter = recordedAfter;
        }

        @Override
        public final Builder recordedAfter(Instant recordedAfter) {
            this.recordedAfter = recordedAfter;
            return this;
        }

        @Override
        public TimestampFilter build() {
            return new TimestampFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
