/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIntegrationTablePropertiesRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateIntegrationTablePropertiesRequest.Builder, UpdateIntegrationTablePropertiesRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(UpdateIntegrationTablePropertiesRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateIntegrationTablePropertiesRequest::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<SourceTableConfig> SOURCE_TABLE_CONFIG_FIELD = SdkField
            .<SourceTableConfig> builder(MarshallingType.SDK_POJO).memberName("SourceTableConfig")
            .getter(getter(UpdateIntegrationTablePropertiesRequest::sourceTableConfig))
            .setter(setter(Builder::sourceTableConfig)).constructor(SourceTableConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableConfig").build()).build();

    private static final SdkField<TargetTableConfig> TARGET_TABLE_CONFIG_FIELD = SdkField
            .<TargetTableConfig> builder(MarshallingType.SDK_POJO).memberName("TargetTableConfig")
            .getter(getter(UpdateIntegrationTablePropertiesRequest::targetTableConfig))
            .setter(setter(Builder::targetTableConfig)).constructor(TargetTableConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TABLE_NAME_FIELD, SOURCE_TABLE_CONFIG_FIELD, TARGET_TABLE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String tableName;

    private final SourceTableConfig sourceTableConfig;

    private final TargetTableConfig targetTableConfig;

    private UpdateIntegrationTablePropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.tableName = builder.tableName;
        this.sourceTableConfig = builder.sourceTableConfig;
        this.targetTableConfig = builder.targetTableConfig;
    }

    /**
     * <p>
     * The connection ARN of the source, or the database ARN of the target.
     * </p>
     * 
     * @return The connection ARN of the source, or the database ARN of the target.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The name of the table to be replicated.
     * </p>
     * 
     * @return The name of the table to be replicated.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * A structure for the source table configuration.
     * </p>
     * 
     * @return A structure for the source table configuration.
     */
    public final SourceTableConfig sourceTableConfig() {
        return sourceTableConfig;
    }

    /**
     * <p>
     * A structure for the target table configuration.
     * </p>
     * 
     * @return A structure for the target table configuration.
     */
    public final TargetTableConfig targetTableConfig() {
        return targetTableConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetTableConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIntegrationTablePropertiesRequest)) {
            return false;
        }
        UpdateIntegrationTablePropertiesRequest other = (UpdateIntegrationTablePropertiesRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(sourceTableConfig(), other.sourceTableConfig())
                && Objects.equals(targetTableConfig(), other.targetTableConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIntegrationTablePropertiesRequest").add("ResourceArn", resourceArn())
                .add("TableName", tableName()).add("SourceTableConfig", sourceTableConfig())
                .add("TargetTableConfig", targetTableConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "SourceTableConfig":
            return Optional.ofNullable(clazz.cast(sourceTableConfig()));
        case "TargetTableConfig":
            return Optional.ofNullable(clazz.cast(targetTableConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("SourceTableConfig", SOURCE_TABLE_CONFIG_FIELD);
        map.put("TargetTableConfig", TARGET_TABLE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIntegrationTablePropertiesRequest, T> g) {
        return obj -> g.apply((UpdateIntegrationTablePropertiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIntegrationTablePropertiesRequest> {
        /**
         * <p>
         * The connection ARN of the source, or the database ARN of the target.
         * </p>
         * 
         * @param resourceArn
         *        The connection ARN of the source, or the database ARN of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The name of the table to be replicated.
         * </p>
         * 
         * @param tableName
         *        The name of the table to be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * A structure for the source table configuration.
         * </p>
         * 
         * @param sourceTableConfig
         *        A structure for the source table configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableConfig(SourceTableConfig sourceTableConfig);

        /**
         * <p>
         * A structure for the source table configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceTableConfig.Builder} avoiding the
         * need to create one manually via {@link SourceTableConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceTableConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceTableConfig(SourceTableConfig)}.
         * 
         * @param sourceTableConfig
         *        a consumer that will call methods on {@link SourceTableConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTableConfig(SourceTableConfig)
         */
        default Builder sourceTableConfig(Consumer<SourceTableConfig.Builder> sourceTableConfig) {
            return sourceTableConfig(SourceTableConfig.builder().applyMutation(sourceTableConfig).build());
        }

        /**
         * <p>
         * A structure for the target table configuration.
         * </p>
         * 
         * @param targetTableConfig
         *        A structure for the target table configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetTableConfig(TargetTableConfig targetTableConfig);

        /**
         * <p>
         * A structure for the target table configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetTableConfig.Builder} avoiding the
         * need to create one manually via {@link TargetTableConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetTableConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #targetTableConfig(TargetTableConfig)}.
         * 
         * @param targetTableConfig
         *        a consumer that will call methods on {@link TargetTableConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetTableConfig(TargetTableConfig)
         */
        default Builder targetTableConfig(Consumer<TargetTableConfig.Builder> targetTableConfig) {
            return targetTableConfig(TargetTableConfig.builder().applyMutation(targetTableConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String tableName;

        private SourceTableConfig sourceTableConfig;

        private TargetTableConfig targetTableConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIntegrationTablePropertiesRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            tableName(model.tableName);
            sourceTableConfig(model.sourceTableConfig);
            targetTableConfig(model.targetTableConfig);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final SourceTableConfig.Builder getSourceTableConfig() {
            return sourceTableConfig != null ? sourceTableConfig.toBuilder() : null;
        }

        public final void setSourceTableConfig(SourceTableConfig.BuilderImpl sourceTableConfig) {
            this.sourceTableConfig = sourceTableConfig != null ? sourceTableConfig.build() : null;
        }

        @Override
        public final Builder sourceTableConfig(SourceTableConfig sourceTableConfig) {
            this.sourceTableConfig = sourceTableConfig;
            return this;
        }

        public final TargetTableConfig.Builder getTargetTableConfig() {
            return targetTableConfig != null ? targetTableConfig.toBuilder() : null;
        }

        public final void setTargetTableConfig(TargetTableConfig.BuilderImpl targetTableConfig) {
            this.targetTableConfig = targetTableConfig != null ? targetTableConfig.build() : null;
        }

        @Override
        public final Builder targetTableConfig(TargetTableConfig targetTableConfig) {
            this.targetTableConfig = targetTableConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIntegrationTablePropertiesRequest build() {
            return new UpdateIntegrationTablePropertiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
