/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataQualityEncryptionMode {
    DISABLED("DISABLED"),
    SSE_KMS("SSE-KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataQualityEncryptionMode> VALUE_MAP;
    private final String value;

    private DataQualityEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataQualityEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataQualityEncryptionMode> knownValues() {
        EnumSet<DataQualityEncryptionMode> knownValues = EnumSet.allOf(DataQualityEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataQualityEncryptionMode.class, DataQualityEncryptionMode::toString);
    }
}

