/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.grafana.model.AccountAccessType;
import software.amazon.awssdk.services.grafana.model.AuthenticationSummary;
import software.amazon.awssdk.services.grafana.model.DataSourceType;
import software.amazon.awssdk.services.grafana.model.DataSourceTypesListCopier;
import software.amazon.awssdk.services.grafana.model.LicenseType;
import software.amazon.awssdk.services.grafana.model.NetworkAccessConfiguration;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationType;
import software.amazon.awssdk.services.grafana.model.NotificationDestinationsListCopier;
import software.amazon.awssdk.services.grafana.model.OrganizationalUnitListCopier;
import software.amazon.awssdk.services.grafana.model.PermissionType;
import software.amazon.awssdk.services.grafana.model.TagMapCopier;
import software.amazon.awssdk.services.grafana.model.VpcConfiguration;
import software.amazon.awssdk.services.grafana.model.WorkspaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkspaceDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkspaceDescription> {
    private static final SdkField<String> ACCOUNT_ACCESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountAccessType").getter(WorkspaceDescription.getter(WorkspaceDescription::accountAccessTypeAsString)).setter(WorkspaceDescription.setter(Builder::accountAccessType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountAccessType").build()}).build();
    private static final SdkField<AuthenticationSummary> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authentication").getter(WorkspaceDescription.getter(WorkspaceDescription::authentication)).setter(WorkspaceDescription.setter(Builder::authentication)).constructor(AuthenticationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authentication").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(WorkspaceDescription.getter(WorkspaceDescription::created)).setter(WorkspaceDescription.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<List<String>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataSources").getter(WorkspaceDescription.getter(WorkspaceDescription::dataSourcesAsStrings)).setter(WorkspaceDescription.setter(Builder::dataSourcesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkspaceDescription.getter(WorkspaceDescription::description)).setter(WorkspaceDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(WorkspaceDescription.getter(WorkspaceDescription::endpoint)).setter(WorkspaceDescription.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Boolean> FREE_TRIAL_CONSUMED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("freeTrialConsumed").getter(WorkspaceDescription.getter(WorkspaceDescription::freeTrialConsumed)).setter(WorkspaceDescription.setter(Builder::freeTrialConsumed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialConsumed").build()}).build();
    private static final SdkField<Instant> FREE_TRIAL_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("freeTrialExpiration").getter(WorkspaceDescription.getter(WorkspaceDescription::freeTrialExpiration)).setter(WorkspaceDescription.setter(Builder::freeTrialExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialExpiration").build()}).build();
    private static final SdkField<String> GRAFANA_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaToken").getter(WorkspaceDescription.getter(WorkspaceDescription::grafanaToken)).setter(WorkspaceDescription.setter(Builder::grafanaToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaToken").build()}).build();
    private static final SdkField<String> GRAFANA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("grafanaVersion").getter(WorkspaceDescription.getter(WorkspaceDescription::grafanaVersion)).setter(WorkspaceDescription.setter(Builder::grafanaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grafanaVersion").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(WorkspaceDescription.getter(WorkspaceDescription::id)).setter(WorkspaceDescription.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LICENSE_EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("licenseExpiration").getter(WorkspaceDescription.getter(WorkspaceDescription::licenseExpiration)).setter(WorkspaceDescription.setter(Builder::licenseExpiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseExpiration").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseType").getter(WorkspaceDescription.getter(WorkspaceDescription::licenseTypeAsString)).setter(WorkspaceDescription.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseType").build()}).build();
    private static final SdkField<Instant> MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("modified").getter(WorkspaceDescription.getter(WorkspaceDescription::modified)).setter(WorkspaceDescription.setter(Builder::modified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modified").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WorkspaceDescription.getter(WorkspaceDescription::name)).setter(WorkspaceDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkAccessControl").getter(WorkspaceDescription.getter(WorkspaceDescription::networkAccessControl)).setter(WorkspaceDescription.setter(Builder::networkAccessControl)).constructor(NetworkAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkAccessControl").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationDestinations").getter(WorkspaceDescription.getter(WorkspaceDescription::notificationDestinationsAsStrings)).setter(WorkspaceDescription.setter(Builder::notificationDestinationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ORGANIZATION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRoleName").getter(WorkspaceDescription.getter(WorkspaceDescription::organizationRoleName)).setter(WorkspaceDescription.setter(Builder::organizationRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRoleName").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationalUnits").getter(WorkspaceDescription.getter(WorkspaceDescription::organizationalUnits)).setter(WorkspaceDescription.setter(Builder::organizationalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionType").getter(WorkspaceDescription.getter(WorkspaceDescription::permissionTypeAsString)).setter(WorkspaceDescription.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionType").build()}).build();
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackSetName").getter(WorkspaceDescription.getter(WorkspaceDescription::stackSetName)).setter(WorkspaceDescription.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackSetName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkspaceDescription.getter(WorkspaceDescription::statusAsString)).setter(WorkspaceDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(WorkspaceDescription.getter(WorkspaceDescription::tags)).setter(WorkspaceDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfiguration").getter(WorkspaceDescription.getter(WorkspaceDescription::vpcConfiguration)).setter(WorkspaceDescription.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()}).build();
    private static final SdkField<String> WORKSPACE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceRoleArn").getter(WorkspaceDescription.getter(WorkspaceDescription::workspaceRoleArn)).setter(WorkspaceDescription.setter(Builder::workspaceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaceRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ACCESS_TYPE_FIELD, AUTHENTICATION_FIELD, CREATED_FIELD, DATA_SOURCES_FIELD, DESCRIPTION_FIELD, ENDPOINT_FIELD, FREE_TRIAL_CONSUMED_FIELD, FREE_TRIAL_EXPIRATION_FIELD, GRAFANA_TOKEN_FIELD, GRAFANA_VERSION_FIELD, ID_FIELD, LICENSE_EXPIRATION_FIELD, LICENSE_TYPE_FIELD, MODIFIED_FIELD, NAME_FIELD, NETWORK_ACCESS_CONTROL_FIELD, NOTIFICATION_DESTINATIONS_FIELD, ORGANIZATION_ROLE_NAME_FIELD, ORGANIZATIONAL_UNITS_FIELD, PERMISSION_TYPE_FIELD, STACK_SET_NAME_FIELD, STATUS_FIELD, TAGS_FIELD, VPC_CONFIGURATION_FIELD, WORKSPACE_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkspaceDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountAccessType;
    private final AuthenticationSummary authentication;
    private final Instant created;
    private final List<String> dataSources;
    private final String description;
    private final String endpoint;
    private final Boolean freeTrialConsumed;
    private final Instant freeTrialExpiration;
    private final String grafanaToken;
    private final String grafanaVersion;
    private final String id;
    private final Instant licenseExpiration;
    private final String licenseType;
    private final Instant modified;
    private final String name;
    private final NetworkAccessConfiguration networkAccessControl;
    private final List<String> notificationDestinations;
    private final String organizationRoleName;
    private final List<String> organizationalUnits;
    private final String permissionType;
    private final String stackSetName;
    private final String status;
    private final Map<String, String> tags;
    private final VpcConfiguration vpcConfiguration;
    private final String workspaceRoleArn;

    private WorkspaceDescription(BuilderImpl builder) {
        this.accountAccessType = builder.accountAccessType;
        this.authentication = builder.authentication;
        this.created = builder.created;
        this.dataSources = builder.dataSources;
        this.description = builder.description;
        this.endpoint = builder.endpoint;
        this.freeTrialConsumed = builder.freeTrialConsumed;
        this.freeTrialExpiration = builder.freeTrialExpiration;
        this.grafanaToken = builder.grafanaToken;
        this.grafanaVersion = builder.grafanaVersion;
        this.id = builder.id;
        this.licenseExpiration = builder.licenseExpiration;
        this.licenseType = builder.licenseType;
        this.modified = builder.modified;
        this.name = builder.name;
        this.networkAccessControl = builder.networkAccessControl;
        this.notificationDestinations = builder.notificationDestinations;
        this.organizationRoleName = builder.organizationRoleName;
        this.organizationalUnits = builder.organizationalUnits;
        this.permissionType = builder.permissionType;
        this.stackSetName = builder.stackSetName;
        this.status = builder.status;
        this.tags = builder.tags;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.workspaceRoleArn = builder.workspaceRoleArn;
    }

    public final AccountAccessType accountAccessType() {
        return AccountAccessType.fromValue(this.accountAccessType);
    }

    public final String accountAccessTypeAsString() {
        return this.accountAccessType;
    }

    public final AuthenticationSummary authentication() {
        return this.authentication;
    }

    public final Instant created() {
        return this.created;
    }

    public final List<DataSourceType> dataSources() {
        return DataSourceTypesListCopier.copyStringToEnum(this.dataSources);
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<String> dataSourcesAsStrings() {
        return this.dataSources;
    }

    public final String description() {
        return this.description;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Boolean freeTrialConsumed() {
        return this.freeTrialConsumed;
    }

    public final Instant freeTrialExpiration() {
        return this.freeTrialExpiration;
    }

    public final String grafanaToken() {
        return this.grafanaToken;
    }

    public final String grafanaVersion() {
        return this.grafanaVersion;
    }

    public final String id() {
        return this.id;
    }

    public final Instant licenseExpiration() {
        return this.licenseExpiration;
    }

    public final LicenseType licenseType() {
        return LicenseType.fromValue(this.licenseType);
    }

    public final String licenseTypeAsString() {
        return this.licenseType;
    }

    public final Instant modified() {
        return this.modified;
    }

    public final String name() {
        return this.name;
    }

    public final NetworkAccessConfiguration networkAccessControl() {
        return this.networkAccessControl;
    }

    public final List<NotificationDestinationType> notificationDestinations() {
        return NotificationDestinationsListCopier.copyStringToEnum(this.notificationDestinations);
    }

    public final boolean hasNotificationDestinations() {
        return this.notificationDestinations != null && !(this.notificationDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> notificationDestinationsAsStrings() {
        return this.notificationDestinations;
    }

    public final String organizationRoleName() {
        return this.organizationRoleName;
    }

    public final boolean hasOrganizationalUnits() {
        return this.organizationalUnits != null && !(this.organizationalUnits instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnits() {
        return this.organizationalUnits;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final WorkspaceStatus status() {
        return WorkspaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String workspaceRoleArn() {
        return this.workspaceRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAccessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSourcesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTrialConsumed());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTrialExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.grafanaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseExpiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modified());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAccessControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationDestinations() ? this.notificationDestinationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnits() ? this.organizationalUnits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceDescription)) {
            return false;
        }
        WorkspaceDescription other = (WorkspaceDescription)obj;
        return Objects.equals(this.accountAccessTypeAsString(), other.accountAccessTypeAsString()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.created(), other.created()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSourcesAsStrings(), other.dataSourcesAsStrings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.freeTrialConsumed(), other.freeTrialConsumed()) && Objects.equals(this.freeTrialExpiration(), other.freeTrialExpiration()) && Objects.equals(this.grafanaToken(), other.grafanaToken()) && Objects.equals(this.grafanaVersion(), other.grafanaVersion()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.licenseExpiration(), other.licenseExpiration()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.modified(), other.modified()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.networkAccessControl(), other.networkAccessControl()) && this.hasNotificationDestinations() == other.hasNotificationDestinations() && Objects.equals(this.notificationDestinationsAsStrings(), other.notificationDestinationsAsStrings()) && Objects.equals(this.organizationRoleName(), other.organizationRoleName()) && this.hasOrganizationalUnits() == other.hasOrganizationalUnits() && Objects.equals(this.organizationalUnits(), other.organizationalUnits()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.workspaceRoleArn(), other.workspaceRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"WorkspaceDescription").add("AccountAccessType", (Object)this.accountAccessTypeAsString()).add("Authentication", (Object)this.authentication()).add("Created", (Object)this.created()).add("DataSources", this.hasDataSources() ? this.dataSourcesAsStrings() : null).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Endpoint", (Object)this.endpoint()).add("FreeTrialConsumed", (Object)this.freeTrialConsumed()).add("FreeTrialExpiration", (Object)this.freeTrialExpiration()).add("GrafanaToken", (Object)this.grafanaToken()).add("GrafanaVersion", (Object)this.grafanaVersion()).add("Id", (Object)this.id()).add("LicenseExpiration", (Object)this.licenseExpiration()).add("LicenseType", (Object)this.licenseTypeAsString()).add("Modified", (Object)this.modified()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("NetworkAccessControl", (Object)this.networkAccessControl()).add("NotificationDestinations", this.hasNotificationDestinations() ? this.notificationDestinationsAsStrings() : null).add("OrganizationRoleName", (Object)(this.organizationRoleName() == null ? null : "*** Sensitive Data Redacted ***")).add("OrganizationalUnits", (Object)(this.organizationalUnits() == null ? null : "*** Sensitive Data Redacted ***")).add("PermissionType", (Object)this.permissionTypeAsString()).add("StackSetName", (Object)this.stackSetName()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("WorkspaceRoleArn", (Object)(this.workspaceRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountAccessType": {
                return Optional.ofNullable(clazz.cast(this.accountAccessTypeAsString()));
            }
            case "authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "dataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSourcesAsStrings()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "freeTrialConsumed": {
                return Optional.ofNullable(clazz.cast(this.freeTrialConsumed()));
            }
            case "freeTrialExpiration": {
                return Optional.ofNullable(clazz.cast(this.freeTrialExpiration()));
            }
            case "grafanaToken": {
                return Optional.ofNullable(clazz.cast(this.grafanaToken()));
            }
            case "grafanaVersion": {
                return Optional.ofNullable(clazz.cast(this.grafanaVersion()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "licenseExpiration": {
                return Optional.ofNullable(clazz.cast(this.licenseExpiration()));
            }
            case "licenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "modified": {
                return Optional.ofNullable(clazz.cast(this.modified()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "networkAccessControl": {
                return Optional.ofNullable(clazz.cast(this.networkAccessControl()));
            }
            case "notificationDestinations": {
                return Optional.ofNullable(clazz.cast(this.notificationDestinationsAsStrings()));
            }
            case "organizationRoleName": {
                return Optional.ofNullable(clazz.cast(this.organizationRoleName()));
            }
            case "organizationalUnits": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnits()));
            }
            case "permissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "stackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "workspaceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.workspaceRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountAccessType", ACCOUNT_ACCESS_TYPE_FIELD);
        map.put("authentication", AUTHENTICATION_FIELD);
        map.put("created", CREATED_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("freeTrialConsumed", FREE_TRIAL_CONSUMED_FIELD);
        map.put("freeTrialExpiration", FREE_TRIAL_EXPIRATION_FIELD);
        map.put("grafanaToken", GRAFANA_TOKEN_FIELD);
        map.put("grafanaVersion", GRAFANA_VERSION_FIELD);
        map.put("id", ID_FIELD);
        map.put("licenseExpiration", LICENSE_EXPIRATION_FIELD);
        map.put("licenseType", LICENSE_TYPE_FIELD);
        map.put("modified", MODIFIED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkAccessControl", NETWORK_ACCESS_CONTROL_FIELD);
        map.put("notificationDestinations", NOTIFICATION_DESTINATIONS_FIELD);
        map.put("organizationRoleName", ORGANIZATION_ROLE_NAME_FIELD);
        map.put("organizationalUnits", ORGANIZATIONAL_UNITS_FIELD);
        map.put("permissionType", PERMISSION_TYPE_FIELD);
        map.put("stackSetName", STACK_SET_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("workspaceRoleArn", WORKSPACE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceDescription, T> g) {
        return obj -> g.apply((WorkspaceDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountAccessType;
        private AuthenticationSummary authentication;
        private Instant created;
        private List<String> dataSources = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String endpoint;
        private Boolean freeTrialConsumed;
        private Instant freeTrialExpiration;
        private String grafanaToken;
        private String grafanaVersion;
        private String id;
        private Instant licenseExpiration;
        private String licenseType;
        private Instant modified;
        private String name;
        private NetworkAccessConfiguration networkAccessControl;
        private List<String> notificationDestinations = DefaultSdkAutoConstructList.getInstance();
        private String organizationRoleName;
        private List<String> organizationalUnits = DefaultSdkAutoConstructList.getInstance();
        private String permissionType;
        private String stackSetName;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private VpcConfiguration vpcConfiguration;
        private String workspaceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceDescription model) {
            this.accountAccessType(model.accountAccessType);
            this.authentication(model.authentication);
            this.created(model.created);
            this.dataSourcesWithStrings(model.dataSources);
            this.description(model.description);
            this.endpoint(model.endpoint);
            this.freeTrialConsumed(model.freeTrialConsumed);
            this.freeTrialExpiration(model.freeTrialExpiration);
            this.grafanaToken(model.grafanaToken);
            this.grafanaVersion(model.grafanaVersion);
            this.id(model.id);
            this.licenseExpiration(model.licenseExpiration);
            this.licenseType(model.licenseType);
            this.modified(model.modified);
            this.name(model.name);
            this.networkAccessControl(model.networkAccessControl);
            this.notificationDestinationsWithStrings(model.notificationDestinations);
            this.organizationRoleName(model.organizationRoleName);
            this.organizationalUnits(model.organizationalUnits);
            this.permissionType(model.permissionType);
            this.stackSetName(model.stackSetName);
            this.status(model.status);
            this.tags(model.tags);
            this.vpcConfiguration(model.vpcConfiguration);
            this.workspaceRoleArn(model.workspaceRoleArn);
        }

        public final String getAccountAccessType() {
            return this.accountAccessType;
        }

        public final void setAccountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
        }

        @Override
        public final Builder accountAccessType(String accountAccessType) {
            this.accountAccessType = accountAccessType;
            return this;
        }

        @Override
        public final Builder accountAccessType(AccountAccessType accountAccessType) {
            this.accountAccessType(accountAccessType == null ? null : accountAccessType.toString());
            return this;
        }

        public final AuthenticationSummary.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(AuthenticationSummary.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(AuthenticationSummary authentication) {
            this.authentication = authentication;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Collection<String> getDataSources() {
            if (this.dataSources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSources;
        }

        public final void setDataSources(Collection<String> dataSources) {
            this.dataSources = DataSourceTypesListCopier.copy(dataSources);
        }

        @Override
        public final Builder dataSourcesWithStrings(Collection<String> dataSources) {
            this.dataSources = DataSourceTypesListCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSourcesWithStrings(String ... dataSources) {
            this.dataSourcesWithStrings(Arrays.asList(dataSources));
            return this;
        }

        @Override
        public final Builder dataSources(Collection<DataSourceType> dataSources) {
            this.dataSources = DataSourceTypesListCopier.copyEnumToString(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSourceType ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getFreeTrialConsumed() {
            return this.freeTrialConsumed;
        }

        public final void setFreeTrialConsumed(Boolean freeTrialConsumed) {
            this.freeTrialConsumed = freeTrialConsumed;
        }

        @Override
        public final Builder freeTrialConsumed(Boolean freeTrialConsumed) {
            this.freeTrialConsumed = freeTrialConsumed;
            return this;
        }

        public final Instant getFreeTrialExpiration() {
            return this.freeTrialExpiration;
        }

        public final void setFreeTrialExpiration(Instant freeTrialExpiration) {
            this.freeTrialExpiration = freeTrialExpiration;
        }

        @Override
        public final Builder freeTrialExpiration(Instant freeTrialExpiration) {
            this.freeTrialExpiration = freeTrialExpiration;
            return this;
        }

        public final String getGrafanaToken() {
            return this.grafanaToken;
        }

        public final void setGrafanaToken(String grafanaToken) {
            this.grafanaToken = grafanaToken;
        }

        @Override
        public final Builder grafanaToken(String grafanaToken) {
            this.grafanaToken = grafanaToken;
            return this;
        }

        public final String getGrafanaVersion() {
            return this.grafanaVersion;
        }

        public final void setGrafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
        }

        @Override
        public final Builder grafanaVersion(String grafanaVersion) {
            this.grafanaVersion = grafanaVersion;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLicenseExpiration() {
            return this.licenseExpiration;
        }

        public final void setLicenseExpiration(Instant licenseExpiration) {
            this.licenseExpiration = licenseExpiration;
        }

        @Override
        public final Builder licenseExpiration(Instant licenseExpiration) {
            this.licenseExpiration = licenseExpiration;
            return this;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(LicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final Instant getModified() {
            return this.modified;
        }

        public final void setModified(Instant modified) {
            this.modified = modified;
        }

        @Override
        public final Builder modified(Instant modified) {
            this.modified = modified;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessControl() {
            return this.networkAccessControl != null ? this.networkAccessControl.toBuilder() : null;
        }

        public final void setNetworkAccessControl(NetworkAccessConfiguration.BuilderImpl networkAccessControl) {
            this.networkAccessControl = networkAccessControl != null ? networkAccessControl.build() : null;
        }

        @Override
        public final Builder networkAccessControl(NetworkAccessConfiguration networkAccessControl) {
            this.networkAccessControl = networkAccessControl;
            return this;
        }

        public final Collection<String> getNotificationDestinations() {
            if (this.notificationDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationDestinations;
        }

        public final void setNotificationDestinations(Collection<String> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copy(notificationDestinations);
        }

        @Override
        public final Builder notificationDestinationsWithStrings(Collection<String> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copy(notificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationDestinationsWithStrings(String ... notificationDestinations) {
            this.notificationDestinationsWithStrings(Arrays.asList(notificationDestinations));
            return this;
        }

        @Override
        public final Builder notificationDestinations(Collection<NotificationDestinationType> notificationDestinations) {
            this.notificationDestinations = NotificationDestinationsListCopier.copyEnumToString(notificationDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationDestinations(NotificationDestinationType ... notificationDestinations) {
            this.notificationDestinations(Arrays.asList(notificationDestinations));
            return this;
        }

        public final String getOrganizationRoleName() {
            return this.organizationRoleName;
        }

        public final void setOrganizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
        }

        @Override
        public final Builder organizationRoleName(String organizationRoleName) {
            this.organizationRoleName = organizationRoleName;
            return this;
        }

        public final Collection<String> getOrganizationalUnits() {
            if (this.organizationalUnits instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnits;
        }

        public final void setOrganizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitListCopier.copy(organizationalUnits);
        }

        @Override
        public final Builder organizationalUnits(Collection<String> organizationalUnits) {
            this.organizationalUnits = OrganizationalUnitListCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(String ... organizationalUnits) {
            this.organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkspaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getWorkspaceRoleArn() {
            return this.workspaceRoleArn;
        }

        public final void setWorkspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
        }

        @Override
        public final Builder workspaceRoleArn(String workspaceRoleArn) {
            this.workspaceRoleArn = workspaceRoleArn;
            return this;
        }

        public WorkspaceDescription build() {
            return new WorkspaceDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkspaceDescription> {
        public Builder accountAccessType(String var1);

        public Builder accountAccessType(AccountAccessType var1);

        public Builder authentication(AuthenticationSummary var1);

        default public Builder authentication(Consumer<AuthenticationSummary.Builder> authentication) {
            return this.authentication((AuthenticationSummary)((AuthenticationSummary.Builder)AuthenticationSummary.builder().applyMutation(authentication)).build());
        }

        public Builder created(Instant var1);

        public Builder dataSourcesWithStrings(Collection<String> var1);

        public Builder dataSourcesWithStrings(String ... var1);

        public Builder dataSources(Collection<DataSourceType> var1);

        public Builder dataSources(DataSourceType ... var1);

        public Builder description(String var1);

        public Builder endpoint(String var1);

        public Builder freeTrialConsumed(Boolean var1);

        public Builder freeTrialExpiration(Instant var1);

        public Builder grafanaToken(String var1);

        public Builder grafanaVersion(String var1);

        public Builder id(String var1);

        public Builder licenseExpiration(Instant var1);

        public Builder licenseType(String var1);

        public Builder licenseType(LicenseType var1);

        public Builder modified(Instant var1);

        public Builder name(String var1);

        public Builder networkAccessControl(NetworkAccessConfiguration var1);

        default public Builder networkAccessControl(Consumer<NetworkAccessConfiguration.Builder> networkAccessControl) {
            return this.networkAccessControl((NetworkAccessConfiguration)((NetworkAccessConfiguration.Builder)NetworkAccessConfiguration.builder().applyMutation(networkAccessControl)).build());
        }

        public Builder notificationDestinationsWithStrings(Collection<String> var1);

        public Builder notificationDestinationsWithStrings(String ... var1);

        public Builder notificationDestinations(Collection<NotificationDestinationType> var1);

        public Builder notificationDestinations(NotificationDestinationType ... var1);

        public Builder organizationRoleName(String var1);

        public Builder organizationalUnits(Collection<String> var1);

        public Builder organizationalUnits(String ... var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder stackSetName(String var1);

        public Builder status(String var1);

        public Builder status(WorkspaceStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder workspaceRoleArn(String var1);
    }
}

