/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Criticality {
    PREFERRED("PREFERRED"),
    REMOVED("REMOVED"),
    REQUIRED("REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Criticality> VALUE_MAP;
    private final String value;

    private Criticality(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Criticality fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Criticality> knownValues() {
        EnumSet<Criticality> knownValues = EnumSet.allOf(Criticality.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Criticality.class, Criticality::toString);
    }
}

