/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EphemerisStatus {
    VALIDATING("VALIDATING"),
    INVALID("INVALID"),
    ERROR("ERROR"),
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    EXPIRED("EXPIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EphemerisStatus> VALUE_MAP;
    private final String value;

    private EphemerisStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EphemerisStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EphemerisStatus> knownValues() {
        EnumSet<EphemerisStatus> knownValues = EnumSet.allOf(EphemerisStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EphemerisStatus.class, EphemerisStatus::toString);
    }
}

