/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.ContactData;
import software.amazon.awssdk.services.groundstation.model.ListContactsRequest;
import software.amazon.awssdk.services.groundstation.model.ListContactsResponse;

public class ListContactsIterable
implements SdkIterable<ListContactsResponse> {
    private final GroundStationClient client;
    private final ListContactsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactsIterable(GroundStationClient client, ListContactsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactsResponseFetcher();
    }

    public Iterator<ListContactsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactData> contactList() {
        Function<ListContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactList() != null) {
                return response.contactList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactsResponseFetcher
    implements SyncPageFetcher<ListContactsResponse> {
        private ListContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactsResponse nextPage(ListContactsResponse previousPage) {
            if (previousPage == null) {
                return ListContactsIterable.this.client.listContacts(ListContactsIterable.this.firstRequest);
            }
            return ListContactsIterable.this.client.listContacts((ListContactsRequest)((Object)ListContactsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

