/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient;
import software.amazon.awssdk.services.groundstation.internal.UserAgentUtils;
import software.amazon.awssdk.services.groundstation.model.EphemerisItem;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesRequest;
import software.amazon.awssdk.services.groundstation.model.ListEphemeridesResponse;

public class ListEphemeridesPublisher
implements SdkPublisher<ListEphemeridesResponse> {
    private final GroundStationAsyncClient client;
    private final ListEphemeridesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEphemeridesPublisher(GroundStationAsyncClient client, ListEphemeridesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEphemeridesPublisher(GroundStationAsyncClient client, ListEphemeridesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEphemeridesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEphemeridesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EphemerisItem> ephemerides() {
        Function<ListEphemeridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ephemerides() != null) {
                return response.ephemerides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEphemeridesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEphemeridesResponseFetcher
    implements AsyncPageFetcher<ListEphemeridesResponse> {
        private ListEphemeridesResponseFetcher() {
        }

        public boolean hasNextPage(ListEphemeridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEphemeridesResponse> nextPage(ListEphemeridesResponse previousPage) {
            if (previousPage == null) {
                return ListEphemeridesPublisher.this.client.listEphemerides(ListEphemeridesPublisher.this.firstRequest);
            }
            return ListEphemeridesPublisher.this.client.listEphemerides((ListEphemeridesRequest)((Object)ListEphemeridesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

