/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventScopeCode {
    PUBLIC("PUBLIC"),
    ACCOUNT_SPECIFIC("ACCOUNT_SPECIFIC"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventScopeCode> VALUE_MAP;
    private final String value;

    private EventScopeCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventScopeCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventScopeCode> knownValues() {
        EnumSet<EventScopeCode> knownValues = EnumSet.allOf(EventScopeCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventScopeCode.class, EventScopeCode::toString);
    }
}

