/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse;

public class DescribeAffectedAccountsForOrganizationIterable
implements SdkIterable<DescribeAffectedAccountsForOrganizationResponse> {
    private final HealthClient client;
    private final DescribeAffectedAccountsForOrganizationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAffectedAccountsForOrganizationIterable(HealthClient client, DescribeAffectedAccountsForOrganizationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAffectedAccountsForOrganizationResponseFetcher();
    }

    public Iterator<DescribeAffectedAccountsForOrganizationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> affectedAccounts() {
        Function<DescribeAffectedAccountsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.affectedAccounts() != null) {
                return response.affectedAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAffectedAccountsForOrganizationResponseFetcher
    implements SyncPageFetcher<DescribeAffectedAccountsForOrganizationResponse> {
        private DescribeAffectedAccountsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAffectedAccountsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAffectedAccountsForOrganizationResponse nextPage(DescribeAffectedAccountsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeAffectedAccountsForOrganizationIterable.this.client.describeAffectedAccountsForOrganization(DescribeAffectedAccountsForOrganizationIterable.this.firstRequest);
            }
            return DescribeAffectedAccountsForOrganizationIterable.this.client.describeAffectedAccountsForOrganization((DescribeAffectedAccountsForOrganizationRequest)((Object)DescribeAffectedAccountsForOrganizationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

