/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.internal.UserAgentUtils;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirImportJobsResponse;

public class ListFHIRImportJobsPublisher
implements SdkPublisher<ListFhirImportJobsResponse> {
    private final HealthLakeAsyncClient client;
    private final ListFhirImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFHIRImportJobsPublisher(HealthLakeAsyncClient client, ListFhirImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFHIRImportJobsPublisher(HealthLakeAsyncClient client, ListFhirImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFhirImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFhirImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFhirImportJobsResponseFetcher
    implements AsyncPageFetcher<ListFhirImportJobsResponse> {
        private ListFhirImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFhirImportJobsResponse> nextPage(ListFhirImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRImportJobsPublisher.this.client.listFHIRImportJobs(ListFHIRImportJobsPublisher.this.firstRequest);
            }
            return ListFHIRImportJobsPublisher.this.client.listFHIRImportJobs((ListFhirImportJobsRequest)((Object)ListFHIRImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

