/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeAsyncClient;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.QueryTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.TableRow;

public class QueryTableRowsPublisher
implements SdkPublisher<QueryTableRowsResponse> {
    private final HoneycodeAsyncClient client;
    private final QueryTableRowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public QueryTableRowsPublisher(HoneycodeAsyncClient client, QueryTableRowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private QueryTableRowsPublisher(HoneycodeAsyncClient client, QueryTableRowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new QueryTableRowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super QueryTableRowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableRow> rows() {
        Function<QueryTableRowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new QueryTableRowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class QueryTableRowsResponseFetcher
    implements AsyncPageFetcher<QueryTableRowsResponse> {
        private QueryTableRowsResponseFetcher() {
        }

        public boolean hasNextPage(QueryTableRowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<QueryTableRowsResponse> nextPage(QueryTableRowsResponse previousPage) {
            if (previousPage == null) {
                return QueryTableRowsPublisher.this.client.queryTableRows(QueryTableRowsPublisher.this.firstRequest);
            }
            return QueryTableRowsPublisher.this.client.queryTableRows((QueryTableRowsRequest)((Object)QueryTableRowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

