/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.zip.Checksum;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class ChecksumSubscriber
implements Subscriber<ByteBuffer> {
    private final CompletableFuture<Void> checksumming = new CompletableFuture();
    private final Collection<Checksum> checksums = new ArrayList<Checksum>();
    private volatile boolean canceled = false;
    private volatile Subscription subscription;

    public ChecksumSubscriber(Collection<? extends Checksum> consumers) {
        this.checksums.addAll(consumers);
        this.checksumming.whenComplete((r, t) -> {
            if (t instanceof CancellationException) {
                ChecksumSubscriber checksumSubscriber = this;
                synchronized (checksumSubscriber) {
                    this.canceled = true;
                    if (this.subscription != null) {
                        this.subscription.cancel();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSubscribe(Subscription subscription) {
        ChecksumSubscriber checksumSubscriber = this;
        synchronized (checksumSubscriber) {
            if (!this.canceled && this.subscription == null) {
                this.subscription = subscription;
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }
    }

    public void onNext(ByteBuffer byteBuffer) {
        if (!this.canceled) {
            byte[] buf;
            if (byteBuffer.hasArray()) {
                buf = byteBuffer.array();
            } else {
                buf = new byte[byteBuffer.remaining()];
                byteBuffer.get(buf);
            }
            this.checksums.forEach(checksum -> checksum.update(buf, 0, buf.length));
        }
    }

    public void onError(Throwable throwable) {
        this.checksumming.completeExceptionally(throwable);
    }

    public void onComplete() {
        this.checksumming.complete(null);
    }

    public CompletableFuture<Void> checksum() {
        return this.checksumming;
    }
}

