/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._policyNameListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupPoliciesResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListGroupPoliciesResponse> {
    private static final SdkField<List<String>> POLICY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyNames").getter(ListGroupPoliciesResponse.getter(ListGroupPoliciesResponse::policyNames)).setter(ListGroupPoliciesResponse.setter(Builder::policyNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListGroupPoliciesResponse.getter(ListGroupPoliciesResponse::isTruncated)).setter(ListGroupPoliciesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListGroupPoliciesResponse.getter(ListGroupPoliciesResponse::marker)).setter(ListGroupPoliciesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAMES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGroupPoliciesResponse.memberNameToFieldInitializer();
    private final List<String> policyNames;
    private final Boolean isTruncated;
    private final String marker;

    private ListGroupPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policyNames = builder.policyNames;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasPolicyNames() {
        return this.policyNames != null && !(this.policyNames instanceof SdkAutoConstructList);
    }

    public final List<String> policyNames() {
        return this.policyNames;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyNames() ? this.policyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupPoliciesResponse)) {
            return false;
        }
        ListGroupPoliciesResponse other = (ListGroupPoliciesResponse)((Object)obj);
        return this.hasPolicyNames() == other.hasPolicyNames() && Objects.equals(this.policyNames(), other.policyNames()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupPoliciesResponse").add("PolicyNames", this.hasPolicyNames() ? this.policyNames() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyNames": {
                return Optional.ofNullable(clazz.cast(this.policyNames()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PolicyNames", POLICY_NAMES_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupPoliciesResponse, T> g) {
        return obj -> g.apply((ListGroupPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<String> policyNames = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupPoliciesResponse model) {
            super(model);
            this.policyNames(model.policyNames);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<String> getPolicyNames() {
            if (this.policyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyNames;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = _policyNameListTypeCopier.copy(policyNames);
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = _policyNameListTypeCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            this.policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListGroupPoliciesResponse build() {
            return new ListGroupPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupPoliciesResponse> {
        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

