/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;

public class ListImageBuildVersionsIterable
implements SdkIterable<ListImageBuildVersionsResponse> {
    private final ImagebuilderClient client;
    private final ListImageBuildVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageBuildVersionsIterable(ImagebuilderClient client, ListImageBuildVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImageBuildVersionsResponseFetcher();
    }

    public Iterator<ListImageBuildVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImageBuildVersionsResponseFetcher
    implements SyncPageFetcher<ListImageBuildVersionsResponse> {
        private ListImageBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageBuildVersionsResponse nextPage(ListImageBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageBuildVersionsIterable.this.client.listImageBuildVersions(ListImageBuildVersionsIterable.this.firstRequest);
            }
            return ListImageBuildVersionsIterable.this.client.listImageBuildVersions((ListImageBuildVersionsRequest)((Object)ListImageBuildVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

