/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;

public class ListImageRecipesIterable
implements SdkIterable<ListImageRecipesResponse> {
    private final ImagebuilderClient client;
    private final ListImageRecipesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageRecipesIterable(ImagebuilderClient client, ListImageRecipesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImageRecipesResponseFetcher();
    }

    public Iterator<ListImageRecipesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListImageRecipesResponseFetcher
    implements SyncPageFetcher<ListImageRecipesResponse> {
        private ListImageRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListImageRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageRecipesResponse nextPage(ListImageRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListImageRecipesIterable.this.client.listImageRecipes(ListImageRecipesIterable.this.firstRequest);
            }
            return ListImageRecipesIterable.this.client.listImageRecipes((ListImageRecipesRequest)((Object)ListImageRecipesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

