/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;

public class ListInfrastructureConfigurationsPublisher
implements SdkPublisher<ListInfrastructureConfigurationsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListInfrastructureConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInfrastructureConfigurationsPublisher(ImagebuilderAsyncClient client, ListInfrastructureConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInfrastructureConfigurationsPublisher(ImagebuilderAsyncClient client, ListInfrastructureConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInfrastructureConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInfrastructureConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInfrastructureConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListInfrastructureConfigurationsResponse> {
        private ListInfrastructureConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInfrastructureConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInfrastructureConfigurationsResponse> nextPage(ListInfrastructureConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListInfrastructureConfigurationsPublisher.this.client.listInfrastructureConfigurations(ListInfrastructureConfigurationsPublisher.this.firstRequest);
            }
            return ListInfrastructureConfigurationsPublisher.this.client.listInfrastructureConfigurations((ListInfrastructureConfigurationsRequest)((Object)ListInfrastructureConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

