/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWaitingWorkflowStepsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListWaitingWorkflowStepsResponse> {
    private static final SdkField<List<WorkflowStepExecution>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(ListWaitingWorkflowStepsResponse.getter(ListWaitingWorkflowStepsResponse::steps)).setter(ListWaitingWorkflowStepsResponse.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStepExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWaitingWorkflowStepsResponse.getter(ListWaitingWorkflowStepsResponse::nextToken)).setter(ListWaitingWorkflowStepsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkflowStepExecution> steps;
    private final String nextToken;

    private ListWaitingWorkflowStepsResponse(BuilderImpl builder) {
        super(builder);
        this.steps = builder.steps;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStepExecution> steps() {
        return this.steps;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWaitingWorkflowStepsResponse)) {
            return false;
        }
        ListWaitingWorkflowStepsResponse other = (ListWaitingWorkflowStepsResponse)((Object)obj);
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWaitingWorkflowStepsResponse").add("Steps", this.hasSteps() ? this.steps() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWaitingWorkflowStepsResponse, T> g) {
        return obj -> g.apply((ListWaitingWorkflowStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private List<WorkflowStepExecution> steps = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWaitingWorkflowStepsResponse model) {
            super(model);
            this.steps(model.steps);
            this.nextToken(model.nextToken);
        }

        public final List<WorkflowStepExecution.Builder> getSteps() {
            List<WorkflowStepExecution.Builder> result = WorkflowStepExecutionListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<WorkflowStepExecution.BuilderImpl> steps) {
            this.steps = WorkflowStepExecutionListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<WorkflowStepExecution> steps) {
            this.steps = WorkflowStepExecutionListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(WorkflowStepExecution ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<WorkflowStepExecution.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (WorkflowStepExecution)((WorkflowStepExecution.Builder)WorkflowStepExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWaitingWorkflowStepsResponse build() {
            return new ListWaitingWorkflowStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWaitingWorkflowStepsResponse> {
        public Builder steps(Collection<WorkflowStepExecution> var1);

        public Builder steps(WorkflowStepExecution ... var1);

        public Builder steps(Consumer<WorkflowStepExecution.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

