/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImageSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse;

public class ListImageBuildVersionsIterable
implements SdkIterable<ListImageBuildVersionsResponse> {
    private final ImagebuilderClient client;
    private final ListImageBuildVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageBuildVersionsIterable(ImagebuilderClient client, ListImageBuildVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImageBuildVersionsResponseFetcher();
    }

    public Iterator<ListImageBuildVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageSummary> imageSummaryList() {
        Function<ListImageBuildVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageSummaryList() != null) {
                return response.imageSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImageBuildVersionsResponseFetcher
    implements SyncPageFetcher<ListImageBuildVersionsResponse> {
        private ListImageBuildVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageBuildVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageBuildVersionsResponse nextPage(ListImageBuildVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageBuildVersionsIterable.this.client.listImageBuildVersions(ListImageBuildVersionsIterable.this.firstRequest);
            }
            return ListImageBuildVersionsIterable.this.client.listImageBuildVersions((ListImageBuildVersionsRequest)((Object)ListImageBuildVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

