/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfigurationSummary;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse;

public class ListInfrastructureConfigurationsIterable
implements SdkIterable<ListInfrastructureConfigurationsResponse> {
    private final ImagebuilderClient client;
    private final ListInfrastructureConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInfrastructureConfigurationsIterable(ImagebuilderClient client, ListInfrastructureConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInfrastructureConfigurationsResponseFetcher();
    }

    public Iterator<ListInfrastructureConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InfrastructureConfigurationSummary> infrastructureConfigurationSummaryList() {
        Function<ListInfrastructureConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.infrastructureConfigurationSummaryList() != null) {
                return response.infrastructureConfigurationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInfrastructureConfigurationsResponseFetcher
    implements SyncPageFetcher<ListInfrastructureConfigurationsResponse> {
        private ListInfrastructureConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInfrastructureConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInfrastructureConfigurationsResponse nextPage(ListInfrastructureConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListInfrastructureConfigurationsIterable.this.client.listInfrastructureConfigurations(ListInfrastructureConfigurationsIterable.this.firstRequest);
            }
            return ListInfrastructureConfigurationsIterable.this.client.listInfrastructureConfigurations((ListInfrastructureConfigurationsRequest)((Object)ListInfrastructureConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

