/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse;

public class ListImageScanFindingsPublisher
implements SdkPublisher<ListImageScanFindingsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImageScanFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageScanFindingsPublisher(ImagebuilderAsyncClient client, ListImageScanFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageScanFindingsPublisher(ImagebuilderAsyncClient client, ListImageScanFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageScanFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageScanFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageScanFinding> findings() {
        Function<ListImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImageScanFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImageScanFindingsResponseFetcher
    implements AsyncPageFetcher<ListImageScanFindingsResponse> {
        private ListImageScanFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageScanFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageScanFindingsResponse> nextPage(ListImageScanFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListImageScanFindingsPublisher.this.client.listImageScanFindings(ListImageScanFindingsPublisher.this.firstRequest);
            }
            return ListImageScanFindingsPublisher.this.client.listImageScanFindings((ListImageScanFindingsRequest)((Object)ListImageScanFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

