/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanningConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderRequest;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateImageRequest
extends ImagebuilderRequest
implements ToCopyableBuilder<Builder, CreateImageRequest> {
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(CreateImageRequest.getter(CreateImageRequest::imageRecipeArn)).setter(CreateImageRequest.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final SdkField<String> CONTAINER_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerRecipeArn").getter(CreateImageRequest.getter(CreateImageRequest::containerRecipeArn)).setter(CreateImageRequest.setter(Builder::containerRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipeArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("distributionConfigurationArn").getter(CreateImageRequest.getter(CreateImageRequest::distributionConfigurationArn)).setter(CreateImageRequest.setter(Builder::distributionConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfigurationArn").build()}).build();
    private static final SdkField<String> INFRASTRUCTURE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("infrastructureConfigurationArn").getter(CreateImageRequest.getter(CreateImageRequest::infrastructureConfigurationArn)).setter(CreateImageRequest.setter(Builder::infrastructureConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfigurationArn").build()}).build();
    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageTestsConfiguration").getter(CreateImageRequest.getter(CreateImageRequest::imageTestsConfiguration)).setter(CreateImageRequest.setter(Builder::imageTestsConfiguration)).constructor(ImageTestsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build()}).build();
    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedImageMetadataEnabled").getter(CreateImageRequest.getter(CreateImageRequest::enhancedImageMetadataEnabled)).setter(CreateImageRequest.setter(Builder::enhancedImageMetadataEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateImageRequest.getter(CreateImageRequest::tags)).setter(CreateImageRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateImageRequest.getter(CreateImageRequest::clientToken)).setter(CreateImageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanningConfiguration").getter(CreateImageRequest.getter(CreateImageRequest::imageScanningConfiguration)).setter(CreateImageRequest.setter(Builder::imageScanningConfiguration)).constructor(ImageScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build()}).build();
    private static final SdkField<List<WorkflowConfiguration>> WORKFLOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workflows").getter(CreateImageRequest.getter(CreateImageRequest::workflows)).setter(CreateImageRequest.setter(Builder::workflows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(CreateImageRequest.getter(CreateImageRequest::executionRole)).setter(CreateImageRequest.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_RECIPE_ARN_FIELD, CONTAINER_RECIPE_ARN_FIELD, DISTRIBUTION_CONFIGURATION_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_ARN_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD, WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("imageRecipeArn", IMAGE_RECIPE_ARN_FIELD);
            this.put("containerRecipeArn", CONTAINER_RECIPE_ARN_FIELD);
            this.put("distributionConfigurationArn", DISTRIBUTION_CONFIGURATION_ARN_FIELD);
            this.put("infrastructureConfigurationArn", INFRASTRUCTURE_CONFIGURATION_ARN_FIELD);
            this.put("imageTestsConfiguration", IMAGE_TESTS_CONFIGURATION_FIELD);
            this.put("enhancedImageMetadataEnabled", ENHANCED_IMAGE_METADATA_ENABLED_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("imageScanningConfiguration", IMAGE_SCANNING_CONFIGURATION_FIELD);
            this.put("workflows", WORKFLOWS_FIELD);
            this.put("executionRole", EXECUTION_ROLE_FIELD);
        }
    });
    private final String imageRecipeArn;
    private final String containerRecipeArn;
    private final String distributionConfigurationArn;
    private final String infrastructureConfigurationArn;
    private final ImageTestsConfiguration imageTestsConfiguration;
    private final Boolean enhancedImageMetadataEnabled;
    private final Map<String, String> tags;
    private final String clientToken;
    private final ImageScanningConfiguration imageScanningConfiguration;
    private final List<WorkflowConfiguration> workflows;
    private final String executionRole;

    private CreateImageRequest(BuilderImpl builder) {
        super(builder);
        this.imageRecipeArn = builder.imageRecipeArn;
        this.containerRecipeArn = builder.containerRecipeArn;
        this.distributionConfigurationArn = builder.distributionConfigurationArn;
        this.infrastructureConfigurationArn = builder.infrastructureConfigurationArn;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
    }

    public final String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public final String containerRecipeArn() {
        return this.containerRecipeArn;
    }

    public final String distributionConfigurationArn() {
        return this.distributionConfigurationArn;
    }

    public final String infrastructureConfigurationArn() {
        return this.infrastructureConfigurationArn;
    }

    public final ImageTestsConfiguration imageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public final Boolean enhancedImageMetadataEnabled() {
        return this.enhancedImageMetadataEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ImageScanningConfiguration imageScanningConfiguration() {
        return this.imageScanningConfiguration;
    }

    public final boolean hasWorkflows() {
        return this.workflows != null && !(this.workflows instanceof SdkAutoConstructList);
    }

    public final List<WorkflowConfiguration> workflows() {
        return this.workflows;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkflows() ? this.workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageRequest)) {
            return false;
        }
        CreateImageRequest other = (CreateImageRequest)((Object)obj);
        return Objects.equals(this.imageRecipeArn(), other.imageRecipeArn()) && Objects.equals(this.containerRecipeArn(), other.containerRecipeArn()) && Objects.equals(this.distributionConfigurationArn(), other.distributionConfigurationArn()) && Objects.equals(this.infrastructureConfigurationArn(), other.infrastructureConfigurationArn()) && Objects.equals(this.imageTestsConfiguration(), other.imageTestsConfiguration()) && Objects.equals(this.enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.imageScanningConfiguration(), other.imageScanningConfiguration()) && this.hasWorkflows() == other.hasWorkflows() && Objects.equals(this.workflows(), other.workflows()) && Objects.equals(this.executionRole(), other.executionRole());
    }

    public final String toString() {
        return ToString.builder((String)"CreateImageRequest").add("ImageRecipeArn", (Object)this.imageRecipeArn()).add("ContainerRecipeArn", (Object)this.containerRecipeArn()).add("DistributionConfigurationArn", (Object)this.distributionConfigurationArn()).add("InfrastructureConfigurationArn", (Object)this.infrastructureConfigurationArn()).add("ImageTestsConfiguration", (Object)this.imageTestsConfiguration()).add("EnhancedImageMetadataEnabled", (Object)this.enhancedImageMetadataEnabled()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("ImageScanningConfiguration", (Object)this.imageScanningConfiguration()).add("Workflows", this.hasWorkflows() ? this.workflows() : null).add("ExecutionRole", (Object)this.executionRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
            case "containerRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.containerRecipeArn()));
            }
            case "distributionConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.distributionConfigurationArn()));
            }
            case "infrastructureConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfigurationArn()));
            }
            case "imageTestsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageTestsConfiguration()));
            }
            case "enhancedImageMetadataEnabled": {
                return Optional.ofNullable(clazz.cast(this.enhancedImageMetadataEnabled()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "imageScanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageScanningConfiguration()));
            }
            case "workflows": {
                return Optional.ofNullable(clazz.cast(this.workflows()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageRequest, T> g) {
        return obj -> g.apply((CreateImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderRequest.BuilderImpl
    implements Builder {
        private String imageRecipeArn;
        private String containerRecipeArn;
        private String distributionConfigurationArn;
        private String infrastructureConfigurationArn;
        private ImageTestsConfiguration imageTestsConfiguration;
        private Boolean enhancedImageMetadataEnabled;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private ImageScanningConfiguration imageScanningConfiguration;
        private List<WorkflowConfiguration> workflows = DefaultSdkAutoConstructList.getInstance();
        private String executionRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageRequest model) {
            super(model);
            this.imageRecipeArn(model.imageRecipeArn);
            this.containerRecipeArn(model.containerRecipeArn);
            this.distributionConfigurationArn(model.distributionConfigurationArn);
            this.infrastructureConfigurationArn(model.infrastructureConfigurationArn);
            this.imageTestsConfiguration(model.imageTestsConfiguration);
            this.enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.imageScanningConfiguration(model.imageScanningConfiguration);
            this.workflows(model.workflows);
            this.executionRole(model.executionRole);
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        public final void setContainerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
        }

        @Override
        public final Builder containerRecipeArn(String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        public final String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        public final void setDistributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
        }

        @Override
        public final Builder distributionConfigurationArn(String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        public final String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        public final void setInfrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
        }

        @Override
        public final Builder infrastructureConfigurationArn(String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return this.imageTestsConfiguration != null ? this.imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return this.imageScanningConfiguration != null ? this.imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final List<WorkflowConfiguration.Builder> getWorkflows() {
            List<WorkflowConfiguration.Builder> result = WorkflowConfigurationListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<WorkflowConfiguration.BuilderImpl> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<WorkflowConfiguration> workflows) {
            this.workflows = WorkflowConfigurationListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(WorkflowConfiguration ... workflows) {
            this.workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<WorkflowConfiguration.Builder> ... workflows) {
            this.workflows(Stream.of(workflows).map(c -> (WorkflowConfiguration)((WorkflowConfiguration.Builder)WorkflowConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageRequest build() {
            return new CreateImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateImageRequest> {
        public Builder imageRecipeArn(String var1);

        public Builder containerRecipeArn(String var1);

        public Builder distributionConfigurationArn(String var1);

        public Builder infrastructureConfigurationArn(String var1);

        public Builder imageTestsConfiguration(ImageTestsConfiguration var1);

        default public Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return this.imageTestsConfiguration((ImageTestsConfiguration)((ImageTestsConfiguration.Builder)ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration)).build());
        }

        public Builder enhancedImageMetadataEnabled(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder imageScanningConfiguration(ImageScanningConfiguration var1);

        default public Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return this.imageScanningConfiguration((ImageScanningConfiguration)((ImageScanningConfiguration.Builder)ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)).build());
        }

        public Builder workflows(Collection<WorkflowConfiguration> var1);

        public Builder workflows(WorkflowConfiguration ... var1);

        public Builder workflows(Consumer<WorkflowConfiguration.Builder> ... var1);

        public Builder executionRole(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

