/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.Certificate;
import software.amazon.awssdk.services.iot.model.CertificatesCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesByCaResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListCertificatesByCaResponse> {
    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("certificates").getter(ListCertificatesByCaResponse.getter(ListCertificatesByCaResponse::certificates)).setter(ListCertificatesByCaResponse.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Certificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextMarker").getter(ListCertificatesByCaResponse.getter(ListCertificatesByCaResponse::nextMarker)).setter(ListCertificatesByCaResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATES_FIELD, NEXT_MARKER_FIELD));
    private final List<Certificate> certificates;
    private final String nextMarker;

    private ListCertificatesByCaResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<Certificate> certificates() {
        return this.certificates;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCaResponse)) {
            return false;
        }
        ListCertificatesByCaResponse other = (ListCertificatesByCaResponse)((Object)obj);
        return this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListCertificatesByCaResponse").add("Certificates", this.hasCertificates() ? this.certificates() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
            case "nextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesByCaResponse, T> g) {
        return obj -> g.apply((ListCertificatesByCaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCaResponse model) {
            super(model);
            this.certificates(model.certificates);
            this.nextMarker(model.nextMarker);
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificatesCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificatesCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (Certificate)((Certificate.Builder)Certificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListCertificatesByCaResponse build() {
            return new ListCertificatesByCaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificatesByCaResponse> {
        public Builder certificates(Collection<Certificate> var1);

        public Builder certificates(Certificate ... var1);

        public Builder certificates(Consumer<Certificate.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

