/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information that identifies the noncompliant resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIdentifier.Builder, ResourceIdentifier> {
    private static final SdkField<String> DEVICE_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceCertificateId").getter(getter(ResourceIdentifier::deviceCertificateId))
            .setter(setter(Builder::deviceCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCertificateId").build())
            .build();

    private static final SdkField<String> CA_CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caCertificateId").getter(getter(ResourceIdentifier::caCertificateId))
            .setter(setter(Builder::caCertificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caCertificateId").build()).build();

    private static final SdkField<String> COGNITO_IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cognitoIdentityPoolId").getter(getter(ResourceIdentifier::cognitoIdentityPoolId))
            .setter(setter(Builder::cognitoIdentityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoIdentityPoolId").build())
            .build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(ResourceIdentifier::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<PolicyVersionIdentifier> POLICY_VERSION_IDENTIFIER_FIELD = SdkField
            .<PolicyVersionIdentifier> builder(MarshallingType.SDK_POJO).memberName("policyVersionIdentifier")
            .getter(getter(ResourceIdentifier::policyVersionIdentifier)).setter(setter(Builder::policyVersionIdentifier))
            .constructor(PolicyVersionIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionIdentifier").build())
            .build();

    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("account")
            .getter(getter(ResourceIdentifier::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(ResourceIdentifier::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> ROLE_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleAliasArn").getter(getter(ResourceIdentifier::roleAliasArn)).setter(setter(Builder::roleAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliasArn").build()).build();

    private static final SdkField<IssuerCertificateIdentifier> ISSUER_CERTIFICATE_IDENTIFIER_FIELD = SdkField
            .<IssuerCertificateIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("issuerCertificateIdentifier")
            .getter(getter(ResourceIdentifier::issuerCertificateIdentifier))
            .setter(setter(Builder::issuerCertificateIdentifier))
            .constructor(IssuerCertificateIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuerCertificateIdentifier")
                    .build()).build();

    private static final SdkField<String> DEVICE_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceCertificateArn").getter(getter(ResourceIdentifier::deviceCertificateArn))
            .setter(setter(Builder::deviceCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCertificateArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_CERTIFICATE_ID_FIELD,
            CA_CERTIFICATE_ID_FIELD, COGNITO_IDENTITY_POOL_ID_FIELD, CLIENT_ID_FIELD, POLICY_VERSION_IDENTIFIER_FIELD,
            ACCOUNT_FIELD, IAM_ROLE_ARN_FIELD, ROLE_ALIAS_ARN_FIELD, ISSUER_CERTIFICATE_IDENTIFIER_FIELD,
            DEVICE_CERTIFICATE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceCertificateId;

    private final String caCertificateId;

    private final String cognitoIdentityPoolId;

    private final String clientId;

    private final PolicyVersionIdentifier policyVersionIdentifier;

    private final String account;

    private final String iamRoleArn;

    private final String roleAliasArn;

    private final IssuerCertificateIdentifier issuerCertificateIdentifier;

    private final String deviceCertificateArn;

    private ResourceIdentifier(BuilderImpl builder) {
        this.deviceCertificateId = builder.deviceCertificateId;
        this.caCertificateId = builder.caCertificateId;
        this.cognitoIdentityPoolId = builder.cognitoIdentityPoolId;
        this.clientId = builder.clientId;
        this.policyVersionIdentifier = builder.policyVersionIdentifier;
        this.account = builder.account;
        this.iamRoleArn = builder.iamRoleArn;
        this.roleAliasArn = builder.roleAliasArn;
        this.issuerCertificateIdentifier = builder.issuerCertificateIdentifier;
        this.deviceCertificateArn = builder.deviceCertificateArn;
    }

    /**
     * <p>
     * The ID of the certificate attached to the resource.
     * </p>
     * 
     * @return The ID of the certificate attached to the resource.
     */
    public final String deviceCertificateId() {
        return deviceCertificateId;
    }

    /**
     * <p>
     * The ID of the CA certificate used to authorize the certificate.
     * </p>
     * 
     * @return The ID of the CA certificate used to authorize the certificate.
     */
    public final String caCertificateId() {
        return caCertificateId;
    }

    /**
     * <p>
     * The ID of the Amazon Cognito identity pool.
     * </p>
     * 
     * @return The ID of the Amazon Cognito identity pool.
     */
    public final String cognitoIdentityPoolId() {
        return cognitoIdentityPoolId;
    }

    /**
     * <p>
     * The client ID.
     * </p>
     * 
     * @return The client ID.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The version of the policy associated with the resource.
     * </p>
     * 
     * @return The version of the policy associated with the resource.
     */
    public final PolicyVersionIdentifier policyVersionIdentifier() {
        return policyVersionIdentifier;
    }

    /**
     * <p>
     * The account with which the resource is associated.
     * </p>
     * 
     * @return The account with which the resource is associated.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The ARN of the IAM role that has overly permissive actions.
     * </p>
     * 
     * @return The ARN of the IAM role that has overly permissive actions.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The ARN of the role alias that has overly permissive actions.
     * </p>
     * 
     * @return The ARN of the role alias that has overly permissive actions.
     */
    public final String roleAliasArn() {
        return roleAliasArn;
    }

    /**
     * <p>
     * The issuer certificate identifier.
     * </p>
     * 
     * @return The issuer certificate identifier.
     */
    public final IssuerCertificateIdentifier issuerCertificateIdentifier() {
        return issuerCertificateIdentifier;
    }

    /**
     * <p>
     * The ARN of the identified device certificate.
     * </p>
     * 
     * @return The ARN of the identified device certificate.
     */
    public final String deviceCertificateArn() {
        return deviceCertificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(cognitoIdentityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(issuerCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deviceCertificateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdentifier)) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier) obj;
        return Objects.equals(deviceCertificateId(), other.deviceCertificateId())
                && Objects.equals(caCertificateId(), other.caCertificateId())
                && Objects.equals(cognitoIdentityPoolId(), other.cognitoIdentityPoolId())
                && Objects.equals(clientId(), other.clientId())
                && Objects.equals(policyVersionIdentifier(), other.policyVersionIdentifier())
                && Objects.equals(account(), other.account()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(roleAliasArn(), other.roleAliasArn())
                && Objects.equals(issuerCertificateIdentifier(), other.issuerCertificateIdentifier())
                && Objects.equals(deviceCertificateArn(), other.deviceCertificateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceIdentifier").add("DeviceCertificateId", deviceCertificateId())
                .add("CaCertificateId", caCertificateId()).add("CognitoIdentityPoolId", cognitoIdentityPoolId())
                .add("ClientId", clientId()).add("PolicyVersionIdentifier", policyVersionIdentifier()).add("Account", account())
                .add("IamRoleArn", iamRoleArn()).add("RoleAliasArn", roleAliasArn())
                .add("IssuerCertificateIdentifier", issuerCertificateIdentifier())
                .add("DeviceCertificateArn", deviceCertificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceCertificateId":
            return Optional.ofNullable(clazz.cast(deviceCertificateId()));
        case "caCertificateId":
            return Optional.ofNullable(clazz.cast(caCertificateId()));
        case "cognitoIdentityPoolId":
            return Optional.ofNullable(clazz.cast(cognitoIdentityPoolId()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "policyVersionIdentifier":
            return Optional.ofNullable(clazz.cast(policyVersionIdentifier()));
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "roleAliasArn":
            return Optional.ofNullable(clazz.cast(roleAliasArn()));
        case "issuerCertificateIdentifier":
            return Optional.ofNullable(clazz.cast(issuerCertificateIdentifier()));
        case "deviceCertificateArn":
            return Optional.ofNullable(clazz.cast(deviceCertificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceCertificateId", DEVICE_CERTIFICATE_ID_FIELD);
        map.put("caCertificateId", CA_CERTIFICATE_ID_FIELD);
        map.put("cognitoIdentityPoolId", COGNITO_IDENTITY_POOL_ID_FIELD);
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("policyVersionIdentifier", POLICY_VERSION_IDENTIFIER_FIELD);
        map.put("account", ACCOUNT_FIELD);
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("roleAliasArn", ROLE_ALIAS_ARN_FIELD);
        map.put("issuerCertificateIdentifier", ISSUER_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("deviceCertificateArn", DEVICE_CERTIFICATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdentifier, T> g) {
        return obj -> g.apply((ResourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIdentifier> {
        /**
         * <p>
         * The ID of the certificate attached to the resource.
         * </p>
         * 
         * @param deviceCertificateId
         *        The ID of the certificate attached to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificateId(String deviceCertificateId);

        /**
         * <p>
         * The ID of the CA certificate used to authorize the certificate.
         * </p>
         * 
         * @param caCertificateId
         *        The ID of the CA certificate used to authorize the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateId(String caCertificateId);

        /**
         * <p>
         * The ID of the Amazon Cognito identity pool.
         * </p>
         * 
         * @param cognitoIdentityPoolId
         *        The ID of the Amazon Cognito identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoIdentityPoolId(String cognitoIdentityPoolId);

        /**
         * <p>
         * The client ID.
         * </p>
         * 
         * @param clientId
         *        The client ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * 
         * @param policyVersionIdentifier
         *        The version of the policy associated with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier);

        /**
         * <p>
         * The version of the policy associated with the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link PolicyVersionIdentifier.Builder} avoiding
         * the need to create one manually via {@link PolicyVersionIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PolicyVersionIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #policyVersionIdentifier(PolicyVersionIdentifier)}.
         * 
         * @param policyVersionIdentifier
         *        a consumer that will call methods on {@link PolicyVersionIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersionIdentifier(PolicyVersionIdentifier)
         */
        default Builder policyVersionIdentifier(Consumer<PolicyVersionIdentifier.Builder> policyVersionIdentifier) {
            return policyVersionIdentifier(PolicyVersionIdentifier.builder().applyMutation(policyVersionIdentifier).build());
        }

        /**
         * <p>
         * The account with which the resource is associated.
         * </p>
         * 
         * @param account
         *        The account with which the resource is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The ARN of the IAM role that has overly permissive actions.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that has overly permissive actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The ARN of the role alias that has overly permissive actions.
         * </p>
         * 
         * @param roleAliasArn
         *        The ARN of the role alias that has overly permissive actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliasArn(String roleAliasArn);

        /**
         * <p>
         * The issuer certificate identifier.
         * </p>
         * 
         * @param issuerCertificateIdentifier
         *        The issuer certificate identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuerCertificateIdentifier(IssuerCertificateIdentifier issuerCertificateIdentifier);

        /**
         * <p>
         * The issuer certificate identifier.
         * </p>
         * This is a convenience method that creates an instance of the {@link IssuerCertificateIdentifier.Builder}
         * avoiding the need to create one manually via {@link IssuerCertificateIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IssuerCertificateIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #issuerCertificateIdentifier(IssuerCertificateIdentifier)}.
         * 
         * @param issuerCertificateIdentifier
         *        a consumer that will call methods on {@link IssuerCertificateIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuerCertificateIdentifier(IssuerCertificateIdentifier)
         */
        default Builder issuerCertificateIdentifier(Consumer<IssuerCertificateIdentifier.Builder> issuerCertificateIdentifier) {
            return issuerCertificateIdentifier(IssuerCertificateIdentifier.builder().applyMutation(issuerCertificateIdentifier)
                    .build());
        }

        /**
         * <p>
         * The ARN of the identified device certificate.
         * </p>
         * 
         * @param deviceCertificateArn
         *        The ARN of the identified device certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCertificateArn(String deviceCertificateArn);
    }

    static final class BuilderImpl implements Builder {
        private String deviceCertificateId;

        private String caCertificateId;

        private String cognitoIdentityPoolId;

        private String clientId;

        private PolicyVersionIdentifier policyVersionIdentifier;

        private String account;

        private String iamRoleArn;

        private String roleAliasArn;

        private IssuerCertificateIdentifier issuerCertificateIdentifier;

        private String deviceCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdentifier model) {
            deviceCertificateId(model.deviceCertificateId);
            caCertificateId(model.caCertificateId);
            cognitoIdentityPoolId(model.cognitoIdentityPoolId);
            clientId(model.clientId);
            policyVersionIdentifier(model.policyVersionIdentifier);
            account(model.account);
            iamRoleArn(model.iamRoleArn);
            roleAliasArn(model.roleAliasArn);
            issuerCertificateIdentifier(model.issuerCertificateIdentifier);
            deviceCertificateArn(model.deviceCertificateArn);
        }

        public final String getDeviceCertificateId() {
            return deviceCertificateId;
        }

        public final void setDeviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
        }

        @Override
        public final Builder deviceCertificateId(String deviceCertificateId) {
            this.deviceCertificateId = deviceCertificateId;
            return this;
        }

        public final String getCaCertificateId() {
            return caCertificateId;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final String getCognitoIdentityPoolId() {
            return cognitoIdentityPoolId;
        }

        public final void setCognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
        }

        @Override
        public final Builder cognitoIdentityPoolId(String cognitoIdentityPoolId) {
            this.cognitoIdentityPoolId = cognitoIdentityPoolId;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final PolicyVersionIdentifier.Builder getPolicyVersionIdentifier() {
            return policyVersionIdentifier != null ? policyVersionIdentifier.toBuilder() : null;
        }

        public final void setPolicyVersionIdentifier(PolicyVersionIdentifier.BuilderImpl policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier != null ? policyVersionIdentifier.build() : null;
        }

        @Override
        public final Builder policyVersionIdentifier(PolicyVersionIdentifier policyVersionIdentifier) {
            this.policyVersionIdentifier = policyVersionIdentifier;
            return this;
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getRoleAliasArn() {
            return roleAliasArn;
        }

        public final void setRoleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
        }

        @Override
        public final Builder roleAliasArn(String roleAliasArn) {
            this.roleAliasArn = roleAliasArn;
            return this;
        }

        public final IssuerCertificateIdentifier.Builder getIssuerCertificateIdentifier() {
            return issuerCertificateIdentifier != null ? issuerCertificateIdentifier.toBuilder() : null;
        }

        public final void setIssuerCertificateIdentifier(IssuerCertificateIdentifier.BuilderImpl issuerCertificateIdentifier) {
            this.issuerCertificateIdentifier = issuerCertificateIdentifier != null ? issuerCertificateIdentifier.build() : null;
        }

        @Override
        public final Builder issuerCertificateIdentifier(IssuerCertificateIdentifier issuerCertificateIdentifier) {
            this.issuerCertificateIdentifier = issuerCertificateIdentifier;
            return this;
        }

        public final String getDeviceCertificateArn() {
            return deviceCertificateArn;
        }

        public final void setDeviceCertificateArn(String deviceCertificateArn) {
            this.deviceCertificateArn = deviceCertificateArn;
        }

        @Override
        public final Builder deviceCertificateArn(String deviceCertificateArn) {
            this.deviceCertificateArn = deviceCertificateArn;
            return this;
        }

        @Override
        public ResourceIdentifier build() {
            return new ResourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
