/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneAsyncClient;
import software.amazon.awssdk.services.iotdataplane.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotdataplane.model.ListRetainedMessagesRequest;
import software.amazon.awssdk.services.iotdataplane.model.ListRetainedMessagesResponse;
import software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary;

public class ListRetainedMessagesPublisher
implements SdkPublisher<ListRetainedMessagesResponse> {
    private final IotDataPlaneAsyncClient client;
    private final ListRetainedMessagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRetainedMessagesPublisher(IotDataPlaneAsyncClient client, ListRetainedMessagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRetainedMessagesPublisher(IotDataPlaneAsyncClient client, ListRetainedMessagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRetainedMessagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRetainedMessagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RetainedMessageSummary> retainedTopics() {
        Function<ListRetainedMessagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.retainedTopics() != null) {
                return response.retainedTopics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRetainedMessagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRetainedMessagesResponseFetcher
    implements AsyncPageFetcher<ListRetainedMessagesResponse> {
        private ListRetainedMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListRetainedMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRetainedMessagesResponse> nextPage(ListRetainedMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListRetainedMessagesPublisher.this.client.listRetainedMessages(ListRetainedMessagesPublisher.this.firstRequest);
            }
            return ListRetainedMessagesPublisher.this.client.listRetainedMessages((ListRetainedMessagesRequest)((Object)ListRetainedMessagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

