/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotSiteWiseAssetModelPropertyIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotSiteWiseAssetModelPropertyIdentifier> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(IotSiteWiseAssetModelPropertyIdentifier.getter(IotSiteWiseAssetModelPropertyIdentifier::assetModelId)).setter(IotSiteWiseAssetModelPropertyIdentifier.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(IotSiteWiseAssetModelPropertyIdentifier.getter(IotSiteWiseAssetModelPropertyIdentifier::propertyId)).setter(IotSiteWiseAssetModelPropertyIdentifier.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, PROPERTY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assetModelId;
    private final String propertyId;

    private IotSiteWiseAssetModelPropertyIdentifier(BuilderImpl builder) {
        this.assetModelId = builder.assetModelId;
        this.propertyId = builder.propertyId;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseAssetModelPropertyIdentifier)) {
            return false;
        }
        IotSiteWiseAssetModelPropertyIdentifier other = (IotSiteWiseAssetModelPropertyIdentifier)obj;
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.propertyId(), other.propertyId());
    }

    public final String toString() {
        return ToString.builder((String)"IotSiteWiseAssetModelPropertyIdentifier").add("AssetModelId", (Object)this.assetModelId()).add("PropertyId", (Object)this.propertyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseAssetModelPropertyIdentifier, T> g) {
        return obj -> g.apply((IotSiteWiseAssetModelPropertyIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetModelId;
        private String propertyId;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseAssetModelPropertyIdentifier model) {
            this.assetModelId(model.assetModelId);
            this.propertyId(model.propertyId);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public IotSiteWiseAssetModelPropertyIdentifier build() {
            return new IotSiteWiseAssetModelPropertyIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotSiteWiseAssetModelPropertyIdentifier> {
        public Builder assetModelId(String var1);

        public Builder propertyId(String var1);
    }
}

